/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.enums;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;

public enum CrmErrorCode implements UniverseErrorCode
{
    UNKNOW(ErrorSide.UNKNOW, Subsystem.UNKNOW, Platform.UNKNOW, 1, "\u672a\u77e5\u7c7b\u578b\u9519\u8bef"),
    CONSULTER_NOT_EXISTS(1002, "\u54a8\u8be2\u7528\u6237\u4e0d\u5b58\u5728"),
    STUDENT_HAS_EXISTS(1003, "\u5ba2\u6237\u5df2\u5b58\u5728"),
    OP_MSG_SWITCH_FAILED(1004, "\u5f00\u542f/\u5173\u95ed\u6d88\u606f\u5f00\u5173\u5931\u8d25"),
    CUSTOM_HAS_EXISTS(ErrorSide.SERVER, Subsystem.CONSULT, Platform.PC, 1001, "\u8be5\u5ba2\u6237\u5df2\u5b58\u5728"),
    NET_WOKR_ERROR(1005, "\u7f51\u7edc\u5f02\u5e38"),
    ILLEGAL_REQUEST(1006, "\u975e\u6cd5\u8bf7\u6c42"),
    GET_CLUE_DETAIL_FAILD(1007, "\u83b7\u53d6\u62db\u751f\u7ebf\u7d22\u5931\u8d25"),
    SAVE_CLUE_INFO_FAILD(1008, "\u4fdd\u5b58\u62db\u751f\u7ebf\u7d22\u5931\u8d25"),
    GET_COMMENTS_FAILD(1009, "\u83b7\u53d6\u8ddf\u8fdb\u8bb0\u5f55\u5931\u8d25"),
    GET_STUDENT_FAILD(1010, "\u83b7\u53d6\u5b66\u5458\u6863\u6848\u5931\u8d25"),
    UNSUPPORT_QUERY(1011, "\u4e0d\u652f\u6301\u7684\u67e5\u8be2\u8bf7\u6c42"),
    SAVE_STUDENT_INFO_FAILD(1012, "\u4fdd\u5b58\u5b66\u5458\u6863\u6848\u5931\u8d25"),
    GET_CURRENT_CLASS_FAILD(1013, "\u83b7\u53d6\u6240\u8bfb\u73ed\u7ea7\u5931\u8d25"),
    GET_HISTORY_CLASS_FAILD(1014, "\u83b7\u53d6\u62a5\u73ed\u8bb0\u5f55\u5931\u8d25"),
    ORG_NOT_EXIST(1015, "\u673a\u6784\u4e0d\u5b58\u5728"),
    FORMAT_ERROR(1016, "\u683c\u5f0f\u9519\u8bef"),
    HANDLER_FAILED(1017, "\u5904\u7406\u5931\u8d25"),
    STUDENT_NOT_EXISTS(1018, "\u673a\u6784\u5b66\u5458\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664"),
    DELETE_STUDENT_FAILD(1019, "\u5220\u9664\u5b66\u5458\u5931\u8d25");

    private ErrorSide errorSide;
    private Subsystem subsystem;
    private Platform platform;
    private int code;
    private String message;

    private CrmErrorCode(ErrorSide errorSide, Subsystem subsystem, Platform platform, int code, String msg) {
        this.errorSide = errorSide;
        this.subsystem = subsystem;
        this.platform = platform;
        this.code = code;
        this.message = msg;
    }

    private CrmErrorCode(int code, String msg) {
        this(ErrorSide.SERVER, Subsystem.ORGANIZATION, Platform.PC, code, msg);
    }

    @Override
    public ErrorSide getErrorSide() {
        return this.errorSide;
    }

    @Override
    public Subsystem getSystem() {
        return this.subsystem;
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public int getSubsystemErrorCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public CrmErrorCode fromCode(int code) {
        for (CrmErrorCode errorCode : CrmErrorCode.values()) {
            if (errorCode.getSubsystemErrorCode() != code) continue;
            return errorCode;
        }
        return UNKNOW;
    }
}

