/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dto.query;

import com.baijia.tianxiao.dto.FieldShow;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ResponseListDto<T> {
    public static PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
    private List<FieldShow> headers;
    private List<List<Object>> datas;

    public ResponseListDto(List<FieldShow> headers, List<T> datas) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.setHeaders(headers);
        this.setDatas(datas);
    }

    private void setHeaders(List<FieldShow> headers) {
        this.headers = headers;
    }

    private void setDatas(List<T> datas) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Preconditions.checkArgument((this.headers != null ? 1 : 0) != 0, (Object)"headers is null! ");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(datas), (Object)"datas is empty!");
        this.datas = Lists.newArrayList();
        for (T t : datas) {
            this.datas.add(this.getObjects(t));
        }
    }

    private List<Object> getObjects(T entry) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"the entry is null!");
        List result = Lists.newArrayList();
        for (FieldShow show : this.headers) {
            if (show == null || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{show.getName()})) continue;
            result.add(propertyUtilsBean.getProperty(entry, show.getName()));
        }
        return result;
    }

    public List<FieldShow> getHeaders() {
        return this.headers;
    }

    public List<List<Object>> getDatas() {
        return this.datas;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseListDto)) {
            return false;
        }
        ResponseListDto other = (ResponseListDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<FieldShow> this$headers = this.getHeaders();
        List<FieldShow> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        List<List<Object>> this$datas = this.getDatas();
        List<List<Object>> other$datas = other.getDatas();
        return !(this$datas == null ? other$datas != null : !((Object)this$datas).equals(other$datas));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseListDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<FieldShow> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        List<List<Object>> $datas = this.getDatas();
        result = result * 59 + ($datas == null ? 43 : ((Object)$datas).hashCode());
        return result;
    }

    public String toString() {
        return "ResponseListDto(headers=" + this.getHeaders() + ", datas=" + this.getDatas() + ")";
    }
}

