/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dto.query;

import com.baijia.tianxiao.dto.FieldShow;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryCondition {
    private static final Logger log = LoggerFactory.getLogger(QueryCondition.class);
    private String fieldName;
    private Serializable lValue;
    private Serializable rValue;

    public QueryCondition(String fieldName, Serializable lValue, Serializable rValue) {
        this.fieldName = fieldName;
        this.lValue = lValue;
        this.rValue = rValue;
    }

    public Expression toExpression(Map<String, FieldShow> mapper) {
        Preconditions.checkArgument((mapper != null ? 1 : 0) != 0, (Object)"mapper = null");
        FieldShow fshow = mapper.get(this.fieldName);
        Preconditions.checkArgument((fshow != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fshow.getPoName()}) ? 1 : 0) != 0, (Object)"can't map to po name");
        Expression exp = null;
        String poName = fshow.getPoName();
        switch (fshow.getType()) {
            case 0: {
                exp = Expressions.like((String)poName, (Serializable)this.lValue);
            }
            case 1: 
            case 2: {
                if (this.lValue != null) {
                    exp = Expressions.ge((String)poName, (Serializable)this.lValue);
                }
                if (this.rValue == null) break;
                exp = exp == null ? Expressions.and((Expression)exp, (Expression)Expressions.le((String)poName, (Serializable)this.rValue)) : Expressions.le((String)poName, (Serializable)this.rValue);
            }
        }
        return exp;
    }

    public static Expression andCondtions(Collection<QueryCondition> conditions, Map<String, FieldShow> mapper) {
        if (CollectionUtils.isEmpty(conditions)) {
            return null;
        }
        Expression exp = null;
        for (QueryCondition con : conditions) {
            Expression e = con.toExpression(mapper);
            if (e == null) continue;
            if (exp == null) {
                exp = e;
                continue;
            }
            exp = Expressions.and((Expression)exp, (Expression)e);
        }
        log.debug("con={},map={},exp = {}", new Object[]{conditions, mapper, exp});
        return exp;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Serializable getLValue() {
        return this.lValue;
    }

    public Serializable getRValue() {
        return this.rValue;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setLValue(Serializable lValue) {
        this.lValue = lValue;
    }

    public void setRValue(Serializable rValue) {
        this.rValue = rValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryCondition)) {
            return false;
        }
        QueryCondition other = (QueryCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        Serializable this$lValue = this.getLValue();
        Serializable other$lValue = other.getLValue();
        if (this$lValue == null ? other$lValue != null : !this$lValue.equals(other$lValue)) {
            return false;
        }
        Serializable this$rValue = this.getRValue();
        Serializable other$rValue = other.getRValue();
        return !(this$rValue == null ? other$rValue != null : !this$rValue.equals(other$rValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryCondition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        Serializable $lValue = this.getLValue();
        result = result * 59 + ($lValue == null ? 43 : $lValue.hashCode());
        Serializable $rValue = this.getRValue();
        result = result * 59 + ($rValue == null ? 43 : $rValue.hashCode());
        return result;
    }

    public String toString() {
        return "QueryCondition(fieldName=" + this.getFieldName() + ", lValue=" + this.getLValue() + ", rValue=" + this.getRValue() + ")";
    }
}

