/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

public class GenericsUtils {
    public static boolean notNullAndEmpty(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            return ((String)obj).length() != 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size() != 0;
        }
        if (obj instanceof Map) {
            return ((Map)obj).size() != 0;
        }
        Class<?> cla = obj.getClass();
        if (cla.isArray()) {
            return Array.getLength(obj) != 0;
        }
        return true;
    }

    public static boolean isNullOrEmpty(Object obj) {
        return !GenericsUtils.notNullAndEmpty(obj);
    }

    public static boolean isNotNull(Field field, Object qm) throws IllegalArgumentException, IllegalAccessException {
        boolean notNull = true;
        Class<?> type = field.getType();
        if (type == Integer.TYPE) {
            boolean bl = notNull = (Integer)field.get(qm) != 0;
        }
        if (type == Double.TYPE) {
            boolean bl = notNull = (Double)field.get(qm) != 0.0;
        }
        if (type == Float.TYPE) {
            boolean bl = notNull = (double)((Float)field.get(qm)).floatValue() != 0.0;
        }
        if (type == Boolean.TYPE) {
            boolean bl = notNull = (Boolean)field.get(qm) != false;
        }
        if (type == Character.TYPE) {
            boolean bl = notNull = ((Character)field.get(qm)).charValue() != '\u0000';
        }
        if (type == Byte.TYPE) {
            boolean bl = notNull = (Byte)field.get(qm) != 0;
        }
        if (type == Short.TYPE) {
            notNull = (Short)field.get(qm) != 0;
        }
        return notNull;
    }

    public static boolean notEqualsIn(String value, boolean ignoreCase, String ... strs) {
        boolean isIn = false;
        for (int i = 0; i < strs.length; ++i) {
            isIn = ignoreCase ? strs[i].equals(value) : strs[i].equalsIgnoreCase(value);
        }
        return isIn;
    }

    public static int indexOfIgnoreCase(String str, int fromIndex) {
        str = str.toLowerCase();
        return str.indexOf(str, fromIndex);
    }

    public static StringBuilder deleteLastChar(StringBuilder sb) {
        if (sb != null && sb.length() > 0) {
            return sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    public static String deleteLastCharToString(StringBuilder sb) {
        return GenericsUtils.deleteLastChar(sb).toString();
    }
}

