/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberUtil {
    private static final Logger log = LoggerFactory.getLogger(NumberUtil.class);
    public static DecimalFormat DOUBLE_FMT = new DecimalFormat("0.00");

    public static BigDecimal multiply(@NonNull Number number1, @NonNull BigDecimal bigDecimal, int scale) {
        if (number1 == null) {
            throw new NullPointerException("number1");
        }
        if (bigDecimal == null) {
            throw new NullPointerException("bigDecimal");
        }
        BigDecimal d1 = new BigDecimal(number1.doubleValue());
        return d1.multiply(bigDecimal).setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal getHuanBi(Number n1, Number n2) {
        BigDecimal result = BigDecimal.ZERO;
        try {
            BigDecimal b2 = BigDecimal.valueOf(n2.doubleValue());
            if (n2 == null || b2.compareTo(new BigDecimal(0)) == 0) {
                return new BigDecimal(0);
            }
            BigDecimal b1 = BigDecimal.valueOf(n1.doubleValue());
            result = b1.subtract(b2).divide(b2, 2, 6);
        }
        catch (Exception e) {
            log.error("[Divide] Error.", (Throwable)e);
        }
        return result;
    }

    public static double get2Double(double a) {
        DecimalFormat df = new DecimalFormat("0.00");
        return new Double(df.format(a).toString());
    }

    public static void main(String[] args) {
        System.out.println(NumberUtil.getHuanBi(10, 0.0));
        Double n = 1.0;
        System.out.println(((Object)n).toString());
    }
}

