/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.annotation;

import com.baijia.tianxiao.annotation.Option;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.enums.PropertiesType;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Snippet {
    private static final Logger log = LoggerFactory.getLogger(Snippet.class);
    private String name;
    private String showName;
    private PropertiesType type;
    private boolean lock;
    private boolean hidden;
    private boolean defaultProp;
    private String queryProp;
    private int sort;

    public static List<Snippet> getAllFields(Class<?> clazz) {
        Field[] fields;
        ArrayList result = Lists.newArrayList();
        for (Field field : fields = clazz.getDeclaredFields()) {
            Option option = field.getAnnotation(Option.class);
            if (option == null) continue;
            Snippet snippet = new Snippet();
            boolean defaultProp = option.defaultProp();
            snippet.setName(option.name());
            snippet.setShowName(option.showName());
            snippet.setDefaultProp(defaultProp);
            snippet.setHidden(option.hidden());
            snippet.setLock(option.lock());
            snippet.setType(option.type());
            snippet.setSort(option.sort());
            String queryProp = option.queryProp();
            if (StringUtils.isNotBlank((CharSequence)queryProp)) {
                snippet.setQueryProp(queryProp);
            } else {
                snippet.setQueryProp(option.name());
            }
            result.add(snippet);
        }
        return result;
    }

    public static List<Snippet> getDefaultFields(Class<?> clazz) {
        Field[] fields;
        ArrayList result = Lists.newArrayList();
        for (Field field : fields = clazz.getDeclaredFields()) {
            Option option = field.getAnnotation(Option.class);
            if (option == null) continue;
            Snippet snippet = new Snippet();
            boolean defaultProp = option.defaultProp();
            if (!defaultProp) continue;
            snippet.setName(option.name());
            snippet.setShowName(option.showName());
            snippet.setDefaultProp(defaultProp);
            snippet.setHidden(option.hidden());
            snippet.setLock(option.lock());
            snippet.setType(option.type());
            snippet.setSort(option.sort());
            String queryProp = option.queryProp();
            if (StringUtils.isNotBlank((CharSequence)queryProp)) {
                snippet.setQueryProp(queryProp);
            } else {
                snippet.setQueryProp(option.name());
            }
            result.add(snippet);
        }
        return result;
    }

    public static void securityCheck(Class<?> clazz, List<Snippet> headers) throws BussinessException {
        Set<String> properties = Snippet.getFields(clazz);
        for (Snippet snippet : headers) {
            String property = snippet.getName();
            if (properties.contains(property)) continue;
            log.info("invalid propertie name:{}", (Object)property);
            throw new BussinessException(CrmErrorCode.ILLEGAL_REQUEST);
        }
    }

    public static Set<String> getFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        HashSet properties = Sets.newHashSet();
        for (Field field : fields) {
            Option option = field.getAnnotation(Option.class);
            if (option == null) continue;
            properties.add(option.name());
        }
        return properties;
    }

    public static Option getAnnotation(Class<?> clazz, String propName) {
        if (StringUtils.isNotBlank((CharSequence)propName)) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Option option;
                String name = field.getName();
                if (!name.equals(propName) || (option = field.getAnnotation(Option.class)) == null) continue;
                return option;
            }
        }
        return null;
    }

    public static void main(String[] args) throws JsonParseException, JsonMappingException, IOException {
        String content = "[{\"name\":\"consulterId\",\"showName\":\"id\",\"type\":\"DIGITAL\",\"lock\":false,\"hidden\":true,\"defaultProp\":true},{\"name\":\"name\",\"showName\":\"\u5b66\u5458\u59d3\u540d\",\"type\":\"STRING\",\"lock\":true,\"hidden\":false,\"defaultProp\":true},{\"name\":\"mobile\",\"showName\":\"\u5b66\u5458\u624b\u673a\",\"type\":\"STRING\",\"lock\":true,\"hidden\":false,\"defaultProp\":true},{\"name\":\"parentName\",\"showName\":\"\u5bb6\u957f\u59d3\u540d\",\"type\":\"STRING\",\"lock\":false,\"hidden\":false,\"defaultProp\":true},{\"name\":\"parentMobile\",\"showName\":\"\u5bb6\u957f\u624b\u673a\",\"type\":\"STRING\",\"lock\":false,\"hidden\":false,\"defaultProp\":true},{\"name\":\"nextRemindTime\",\"showName\":\"\u4e0b\u6b21\u8ddf\u8fdb\u65f6\u95f4\",\"type\":\"DIGITAL\",\"lock\":false,\"hidden\":false,\"defaultProp\":true},{\"name\":\"createTime\",\"showName\":\"\u521b\u5efa\u65f6\u95f4\",\"type\":\"DIGITAL\",\"lock\":false,\"hidden\":false,\"defaultProp\":false}]";
        List<Snippet> snippets = JacksonUtil.str2List(content, Snippet.class);
        for (Snippet snippet : snippets) {
            System.out.println(snippet.getName() + "--" + snippet.getShowName() + "--" + (Object)((Object)snippet.getType()) + "--" + snippet.isDefaultProp() + "--" + snippet.isHidden() + "--" + snippet.isLock());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getShowName() {
        return this.showName;
    }

    public PropertiesType getType() {
        return this.type;
    }

    public boolean isLock() {
        return this.lock;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isDefaultProp() {
        return this.defaultProp;
    }

    public String getQueryProp() {
        return this.queryProp;
    }

    public int getSort() {
        return this.sort;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setShowName(String showName) {
        this.showName = showName;
    }

    public void setType(PropertiesType type) {
        this.type = type;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setDefaultProp(boolean defaultProp) {
        this.defaultProp = defaultProp;
    }

    public void setQueryProp(String queryProp) {
        this.queryProp = queryProp;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Snippet)) {
            return false;
        }
        Snippet other = (Snippet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$showName = this.getShowName();
        String other$showName = other.getShowName();
        if (this$showName == null ? other$showName != null : !this$showName.equals(other$showName)) {
            return false;
        }
        PropertiesType this$type = this.getType();
        PropertiesType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        if (this.isLock() != other.isLock()) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        if (this.isDefaultProp() != other.isDefaultProp()) {
            return false;
        }
        String this$queryProp = this.getQueryProp();
        String other$queryProp = other.getQueryProp();
        if (this$queryProp == null ? other$queryProp != null : !this$queryProp.equals(other$queryProp)) {
            return false;
        }
        return this.getSort() == other.getSort();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Snippet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $showName = this.getShowName();
        result = result * 59 + ($showName == null ? 43 : $showName.hashCode());
        PropertiesType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result = result * 59 + (this.isLock() ? 79 : 97);
        result = result * 59 + (this.isHidden() ? 79 : 97);
        result = result * 59 + (this.isDefaultProp() ? 79 : 97);
        String $queryProp = this.getQueryProp();
        result = result * 59 + ($queryProp == null ? 43 : $queryProp.hashCode());
        result = result * 59 + this.getSort();
        return result;
    }

    public String toString() {
        return "Snippet(name=" + this.getName() + ", showName=" + this.getShowName() + ", type=" + (Object)((Object)this.getType()) + ", lock=" + this.isLock() + ", hidden=" + this.isHidden() + ", defaultProp=" + this.isDefaultProp() + ", queryProp=" + this.getQueryProp() + ", sort=" + this.getSort() + ")";
    }
}

