/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class ParamValidateUtils {
    private static final Pattern MANAGER_EMAIL_PATTERN = Pattern.compile("^[\\w|\\.|\\-]{3,20}@(baijiahulian\\.com|genshuixue\\.com)$");
    private static final Pattern TEACHER_EMAIL_PATTERN = Pattern.compile("^[\\w|\\.|\\-]{3,20}@([\\w|\\-]){3,20}\\.[\\w|\\.|\\-]+$");
    private static final Pattern PASSWD_PATTERN = Pattern.compile("^(([a-z])|([A-Z])|([0-9])|([\\!@#$%\\^\\&\\*\\()\\-_=\\+\\.\\/~\\?\\<\\>:\"\\|])){6,30}$");
    private static final Pattern MOBILE_PATTERN = Pattern.compile("^(\\+?86\\-?)?1\\d{2}\\-?\\d{4}\\-?\\d{4}$");
    private static final Pattern TEL_PATTERN = Pattern.compile("^(\\+?86\\-?)?0\\d{2,3}\\-?\\d{4}\\-?\\d{3,4}$");
    public static final int MIN_PASSWORD_TYPE = 2;

    public static final boolean validateManagerEmail(String email) {
        return StringUtils.isNotBlank((CharSequence)email) && MANAGER_EMAIL_PATTERN.matcher(email).matches();
    }

    public static final boolean validateTeacherEmail(String email) {
        return StringUtils.isNotBlank((CharSequence)email) && TEACHER_EMAIL_PATTERN.matcher(email).matches();
    }

    public static final boolean validateMobile(String mobile) {
        return StringUtils.isNotBlank((CharSequence)mobile) && MOBILE_PATTERN.matcher(mobile).matches();
    }

    public static final boolean validateTel(String tel) {
        return StringUtils.isNotBlank((CharSequence)tel) && (MOBILE_PATTERN.matcher(tel).matches() || TEL_PATTERN.matcher(tel).matches());
    }

    public static final boolean validateManagerName(String name) {
        return StringUtils.isNotBlank((CharSequence)name) && name.length() >= 2 && name.length() <= 10;
    }

    public static final boolean validatePassword(String password) {
        if (StringUtils.isNotBlank((CharSequence)password)) {
            Matcher matcher = PASSWD_PATTERN.matcher(password);
            int hit = 0;
            if (matcher.matches()) {
                hit += StringUtils.isNotBlank((CharSequence)matcher.group(2)) ? 1 : 0;
                hit += StringUtils.isNotBlank((CharSequence)matcher.group(3)) ? 1 : 0;
                hit += StringUtils.isNotBlank((CharSequence)matcher.group(4)) ? 1 : 0;
                hit += StringUtils.isNotBlank((CharSequence)matcher.group(5)) ? 1 : 0;
            }
            return hit >= 2;
        }
        return false;
    }
}

