/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.baidu;

import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dto.baidu.BaiduPlaceEncoderData;
import com.baijia.tianxiao.dto.baidu.BaiduPlaceEncoderResponse;
import com.baijia.tianxiao.dto.baidu.Location;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiduMapUtils {
    private static final Logger log = LoggerFactory.getLogger(BaiduMapUtils.class);

    public static Location getLngAndLat(String address, String area) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((CharSequence)address) || StringUtils.isBlank((CharSequence)area)) {
            return null;
        }
        String location = URLEncoder.encode(address, "UTF-8");
        String region = URLEncoder.encode(area, "UTF-8");
        String api = "http://api.map.baidu.com/place/v2/search?q=" + location + "&region=" + region + "&output=json&ak=D36e39424f92710515ef398cecbe30b6";
        log.info("address:{}", (Object)address);
        String response = HttpClientUtils.doGet(api, null);
        if (StringUtils.isNotBlank((CharSequence)response)) {
            return BaiduMapUtils.parseResponse(response);
        }
        return null;
    }

    private static Location parseResponse(String response) {
        try {
            List<BaiduPlaceEncoderData> result;
            BaiduPlaceEncoderResponse data = JacksonUtil.str2Obj(response, BaiduPlaceEncoderResponse.class);
            if (data != null && data.getStatus() == BizConf.FALSE.intValue() && (result = data.getResults()) != null && !result.isEmpty()) {
                BaiduPlaceEncoderData place = result.get(0);
                return place.getLocation();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

