/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import com.baijia.commons.lang.utils.http.HttpClientUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpForwardUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpForwardUtil.class);
    public static final String CHARSET = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forwardGet(HttpServletResponse response, HttpServletRequest request, String url) {
        try {
            CloseableHttpClient httpclient = HttpClientUtils.getHttpClient();
            BasicHttpContext localContext = new BasicHttpContext();
            if (StringUtils.isNotBlank((String)HttpForwardUtil.getRequestParamStr(request))) {
                url = url + "?" + HttpForwardUtil.getRequestParamStr(request);
            }
            log.info("[WechatUrl]=" + HttpForwardUtil.encodeUrl(url));
            HttpGet httpget = new HttpGet(HttpForwardUtil.encodeUrl(url));
            CloseableHttpResponse result = httpclient.execute((HttpUriRequest)httpget, (HttpContext)localContext);
            try {
                log.info("[Result] Result Code=" + result.getStatusLine().getStatusCode());
                String string = EntityUtils.toString((HttpEntity)result.getEntity(), (String)CHARSET);
                log.info("[Result] Result Content=" + string);
                response.getWriter().print(string);
                response.getWriter().flush();
            }
            finally {
                HttpEntity entity;
                if (response != null && (entity = result.getEntity()) != null) {
                    try {
                        EntityUtils.consume((HttpEntity)entity);
                    }
                    catch (IOException ex) {
                        log.error("[Exception]", (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("[Exception]", (Throwable)e);
        }
    }

    public static void forwardPost(HttpServletResponse response, HttpServletRequest request, String url) {
        try {
            CloseableHttpClient httpclient = HttpClientUtils.getHttpClient();
            BasicHttpContext localContext = new BasicHttpContext();
            log.info("[WechatUrl]=" + HttpForwardUtil.encodeUrl(url));
            Map<String, String> params = HttpForwardUtil.getRequestParamMap(request);
            ArrayList<BasicNameValuePair> pairs = null;
            if (params != null && !params.isEmpty()) {
                pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair(entry.getKey(), value));
                }
            }
            HttpPost httpPost = new HttpPost(HttpForwardUtil.encodeUrl(url));
            if (pairs != null && pairs.size() > 0) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, CHARSET));
            }
            CloseableHttpResponse result = httpclient.execute((HttpUriRequest)httpPost, (HttpContext)localContext);
            InputStream inputStream = result.getEntity().getContent();
            ServletOutputStream out = response.getOutputStream();
            log.info("[Result] Result Code=" + result.getStatusLine().getStatusCode());
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.flush();
        }
        catch (Exception e) {
            log.error("[Exception]", (Throwable)e);
        }
    }

    private static Map<String, String> getRequestParamMap(HttpServletRequest request) {
        Enumeration enums = request.getParameterNames();
        HashMap<String, String> map = new HashMap<String, String>();
        while (enums.hasMoreElements()) {
            String name = (String)enums.nextElement();
            map.put(name, request.getParameter(name));
        }
        return map;
    }

    private static String getRequestParamStr(HttpServletRequest request) {
        Enumeration enums = request.getParameterNames();
        StringBuilder sb = new StringBuilder();
        while (enums.hasMoreElements()) {
            String name = (String)enums.nextElement();
            sb.append("&").append(name).append("=").append(request.getParameter(name));
        }
        if (sb.length() > 0) {
            return sb.substring(1);
        }
        return sb.toString();
    }

    public static String encodeUrl(String urlStr) {
        try {
            URL url = new URL(urlStr);
            String nullFragment = null;
            URI uri = new URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery(), nullFragment);
            return uri.toString();
        }
        catch (MalformedURLException e) {
            log.error("URL " + urlStr + " is a malformed URL");
        }
        catch (URISyntaxException e) {
            log.error("URI " + urlStr + " is a malformed URL");
        }
        return urlStr;
    }
}

