/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.http;

import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.util.http.GSXService;
import java.security.SecureRandom;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtils {
    private static final Logger logger = LoggerFactory.getLogger(RestUtils.class);

    public static RestfulResult<Map<String, Object>> createTeacher(String mobile, Long orgId, String password, String email, String name, String invite_code) throws Exception {
        logger.trace("mobile:" + mobile + ",password:" + password + ",email:" + email + ",name:" + name + ",invite_code:" + invite_code);
        RestfulResult<Map<String, Object>> createResult = null;
        if (StringUtils.isBlank((CharSequence)mobile) || StringUtils.isBlank((CharSequence)password)) {
            createResult = new RestfulResult<Map<String, Object>>();
            createResult.setCode(1);
            createResult.setMsg("\u53c2\u6570\u4e0d\u5b8c\u6574");
            return createResult;
        }
        if (email == null) {
            email = "";
        }
        if (name == null) {
            name = "";
        }
        if (invite_code == null) {
            invite_code = "";
        }
        String controller = "teacher";
        String action = "create";
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("mobile", mobile);
        params.put("password", password);
        params.put("email", email);
        params.put("realname", name);
        params.put("invite_code", invite_code);
        createResult = GSXService.doService(controller, action, params);
        logger.info("ResUtils.createTeacher   params:{}, createResult:{}", params, createResult);
        if (createResult.getCode() == 1) {
            RestUtils.addRole(mobile, orgId, UserRoleEnum.STUDENT.getCode(), invite_code);
        }
        return createResult;
    }

    public static RestfulResult<Map<String, Object>> createTeacherNoMobile(String mobile, Long orgId, String password, String email, String name, String invite_code) throws Exception {
        logger.trace("mobile:" + mobile + ",password:" + password + ",email:" + email + ",name:" + name + ",invite_code:" + invite_code);
        RestfulResult<Map<String, Object>> createResult = null;
        if (email == null) {
            email = "";
        }
        if (name == null) {
            name = "";
        }
        if (invite_code == null) {
            invite_code = "";
        }
        String controller = "teacher";
        String action = "create";
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("email", email);
        params.put("password", password);
        params.put("realname", name);
        params.put("invite_code", invite_code);
        createResult = GSXService.doService(controller, action, params);
        logger.info("ResUtils.createTeacher   params:{}, createResult:{}", params, createResult);
        if (createResult.getCode() == 1) {
            RestUtils.addRole(mobile, orgId, UserRoleEnum.STUDENT.getCode(), invite_code);
        }
        return createResult;
    }

    public static RestfulResult<Map<String, Object>> addRole(String mobile, Long orgId, Integer target_role, String invite_code) throws Exception {
        logger.trace("mobile:" + mobile + ",target_role" + target_role);
        RestfulResult<Map<String, Object>> addResult = null;
        if (StringUtils.isBlank((CharSequence)mobile) || target_role != 0 && target_role != 2) {
            addResult = new RestfulResult<Map<String, Object>>();
            addResult.setCode(1);
            addResult.setMsg("\u53c2\u6570\u4e0d\u5b8c\u6574");
            return addResult;
        }
        String controller = "user";
        String action = "addRole";
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("mobile", mobile);
        params.put("target_role", target_role.toString());
        params.put("invite_code", invite_code);
        if (orgId != null) {
            params.put("org_id", orgId.toString());
        }
        addResult = GSXService.doService(controller, action, params);
        logger.info("ResUtils.addRole   params:{}, addResult:{}", params, addResult);
        return addResult;
    }

    public static RestfulResult<Map<String, Object>> addRole(Long orgId, Integer target_role, String invite_code) throws Exception {
        logger.trace("target_role" + target_role);
        RestfulResult<Map<String, Object>> addResult = null;
        if (target_role != 0 && target_role != 2) {
            addResult = new RestfulResult<Map<String, Object>>();
            addResult.setCode(1);
            addResult.setMsg("\u53c2\u6570\u4e0d\u5b8c\u6574");
            return addResult;
        }
        String controller = "user";
        String action = "addRole";
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("mobile", "");
        params.put("target_role", target_role.toString());
        params.put("invite_code", invite_code);
        if (orgId != null) {
            params.put("org_id", orgId.toString());
        }
        addResult = GSXService.doService(controller, action, params);
        logger.info("ResUtils.addRole   params:{}, addResult:{}", params, addResult);
        return addResult;
    }

    public static String randomPwd(int len) {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[len];
        random.nextBytes(salt);
        char[] saltChars = new char[len];
        int letterPoolSize = TianXiaoConstant.LETTER_POOL.length;
        int numberPoolSize = TianXiaoConstant.NUM_POOL.length;
        for (int i = 0; i < len; ++i) {
            saltChars[i] = i == 0 ? TianXiaoConstant.LETTER_POOL[(salt[i] + 128) % letterPoolSize] : TianXiaoConstant.NUM_POOL[(salt[i] + 128) % numberPoolSize];
        }
        return new String(saltChars);
    }

    public static RestfulResult<Map<String, Object>> createStudent(String mobile, String password, String email, String name, String invite_code) throws Exception {
        String controller = "student";
        String action = "create";
        if (StringUtils.isBlank((CharSequence)password)) {
            password = RestUtils.randomPwd(6);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("mobile:" + mobile + ",password:" + password + ",email:" + email + ",name:" + name + ",invite_code:" + invite_code);
        }
        RestfulResult<Map<String, Object>> createResult = null;
        if (email == null) {
            email = "";
        }
        if (name == null) {
            name = "";
        }
        if (invite_code == null) {
            invite_code = "";
        }
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("mobile", mobile);
        params.put("password", password);
        params.put("email", email);
        params.put("realname", name);
        params.put("invite_code", invite_code);
        createResult = GSXService.doService(controller, action, params);
        logger.info("create student return:{}", createResult);
        if (createResult.getCode() == 100050) {
            RestUtils.addRole(mobile, null, UserRoleEnum.STUDENT.getCode(), invite_code);
        }
        return createResult;
    }

    public static RestfulResult<Map<String, Object>> createStudent(String password, String email, String name, String invite_code) throws Exception {
        String controller = "student";
        String action = "create";
        if (StringUtils.isBlank((CharSequence)password)) {
            password = RestUtils.randomPwd(6);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("password:" + password + ",email:" + email + ",name:" + name + ",invite_code:" + invite_code);
        }
        RestfulResult<Map<String, Object>> createResult = null;
        if (StringUtils.isBlank((CharSequence)password)) {
            createResult = new RestfulResult<Map<String, Object>>();
            createResult.setCode(1);
            createResult.setMsg("\u53c2\u6570\u4e0d\u5b8c\u6574");
            return createResult;
        }
        if (email == null) {
            email = "";
        }
        if (name == null) {
            name = "";
        }
        if (invite_code == null) {
            invite_code = "";
        }
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("password", password);
        params.put("email", email);
        params.put("realname", name);
        params.put("invite_code", invite_code);
        createResult = GSXService.doService(controller, action, params);
        logger.info("create student return:{}", createResult);
        if (createResult.getCode() == 100050) {
            RestUtils.addRole(null, UserRoleEnum.STUDENT.getCode(), invite_code);
        }
        return createResult;
    }
}

