/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.date;

import com.google.common.base.Preconditions;

public class TimeStamp {
    public static final String DEFAULT_TIME_PATTERN = "HH:mm:ss";
    public static final TimeStamp ZERO_TIME = TimeStamp.parse("00:00:00");
    public static final TimeStamp DAY_LAST_TIME = TimeStamp.parse("23:59:59");
    private int hour;
    private int minute;
    private int second;
    private int millisecond;

    public TimeStamp(int hour, int minute, int second) {
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public TimeStamp(int hour, int minute) {
        this.hour = hour;
        this.minute = minute;
    }

    public static TimeStamp parse(String time, String pattern) {
        Preconditions.checkNotNull((Object)time, (Object)"time string is null");
        Preconditions.checkNotNull((Object)pattern, (Object)"pattern can not be null");
        String[] times = time.split(":");
        if (!pattern.equals(DEFAULT_TIME_PATTERN)) {
            // empty if block
        }
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (times.length > 0) {
            hour = Integer.parseInt(times[0]);
        }
        if (times.length > 1) {
            minute = Integer.parseInt(times[1]);
        }
        if (times.length > 2) {
            second = Integer.parseInt(times[2]);
        }
        return new TimeStamp(hour, minute, second);
    }

    public static TimeStamp parse(String time) {
        return TimeStamp.parse(time, DEFAULT_TIME_PATTERN);
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getMillisecond() {
        return this.millisecond;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public void setSecond(int second) {
        this.second = second;
    }

    public void setMillisecond(int millisecond) {
        this.millisecond = millisecond;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeStamp)) {
            return false;
        }
        TimeStamp other = (TimeStamp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHour() != other.getHour()) {
            return false;
        }
        if (this.getMinute() != other.getMinute()) {
            return false;
        }
        if (this.getSecond() != other.getSecond()) {
            return false;
        }
        return this.getMillisecond() == other.getMillisecond();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimeStamp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getHour();
        result = result * 59 + this.getMinute();
        result = result * 59 + this.getSecond();
        result = result * 59 + this.getMillisecond();
        return result;
    }

    public String toString() {
        return "TimeStamp(hour=" + this.getHour() + ", minute=" + this.getMinute() + ", second=" + this.getSecond() + ", millisecond=" + this.getMillisecond() + ")";
    }
}

