
/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.util;


import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author zhangbing
 * @version 1.0
 * @title StringUtils
 * @desc TODO
 * @date 2016年3月23日
 */

public class StringUtils {

    /**
     * 判断字符串str中是否只包含字母和汉字、数字
     *
     * @return
     */
    public static boolean hanziAndLetterValidate(String str) {
        String regex = "[0-9a-zA-Z\u4e00-\u9fa5]*";
        return str.matches(regex);
    }

    /**
     * 判断字符串str中是否只包含数组
     *
     * @return
     */
    public static boolean numberValidate(String str) {
        String regex = "^([0-9])+$";
        return str.matches(regex);
    }

    /**
     * 判断字符串str中是否只包含数组
     *
     * @return
     */
    public static boolean letterValidate(String str) {
        String regex = "^([a-zA-Z])+$";
        return str.matches(regex);
    }

    /**
     * 删除html格式
     *
     * @param htmlStr
     * @return
     */
    public static String delHTMLTag(String htmlStr) {
        String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>"; //定义script的正则表达式
        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>"; //定义style的正则表达式
        String regEx_html = "<[^>]+>"; //定义HTML标签的正则表达式

        Pattern p_script = Pattern.compile(regEx_script, Pattern.CASE_INSENSITIVE);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll(""); //过滤script标签

        Pattern p_style = Pattern.compile(regEx_style, Pattern.CASE_INSENSITIVE);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll(""); //过滤style标签

        Pattern p_html = Pattern.compile(regEx_html, Pattern.CASE_INSENSITIVE);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll(""); //过滤html标签

        return htmlStr.trim(); //返回文本字符串
    }

    public static void main(String[] args) {
        String str = "123asd";
        System.out.print(letterValidate(str));

        System.out.println(str.substring(0, str.length() - 2));
    }
}

    