/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.util;

import java.util.SortedMap;
import java.util.TreeMap;

import com.baijia.tianxiao.constants.SmsGateGroup;
import lombok.extern.slf4j.Slf4j;

import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.util.http.GSXService;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Preconditions;

/**
 * @title SmsSendUtil
 * @desc TODO
 * @author cxm
 * @date 2015年10月26日
 * @version 1.0
 */
@Slf4j
public class SmsSendUtil {

    public static final String ORG_BANK_UNBIND_CARD =
            "尊敬的{shortName},您已成功从跟谁学账户解绑尾号为{cardNo}的银行卡，请知悉，如有疑问，请及时拨打4000-910-910";

    public static final String ORG_BANK_BIND_CARD =
            "尊敬的{shortName}机构,您的跟谁学账户成功绑定了尾号为{cardNo}的银行卡，请知悉，如有疑问，请及时拨打4000-910-910";

    public static boolean sendSms(String mobile, String content, Integer messageType, Integer userId, Integer userRole,
        boolean directSend) {
        RestfulResult<Object> response = send(mobile, content, messageType, userId, userRole, directSend);
        return response.getCode() == 0;
    }

    public static RestfulResult<Object> send(String mobile, String content, Integer messageType, Integer userId,
        Integer userRole, boolean directSend) {
        RestfulResult<Object> response = null;
        try {
            String controller = "sms";
            String action = "send";
            SortedMap<String, String> params = new TreeMap<String, String>();
            params.put("mobile", mobile.replaceAll(" ", "").replace("-", ""));
            Preconditions.checkArgument(ParamValidateUtils.validateMobile(params.get("mobile")),
                "mobile :" + mobile + " is invalidate.");

            params.put("content", content);
            params.put("message_type", String.valueOf(messageType));
            if (userId != null) {
                params.put("user_id", String.valueOf(userId));
            }
            if (userRole != null) {
                params.put("role", String.valueOf(userRole));
            }
            if (directSend) {
                params.put("direct_send", "1");
            }
            if (userId != null) {
                SmsGateGroup smsGateGroup = SmsGateGroup.getByOrgId(userId.intValue());
                if (smsGateGroup != null) {
                    params.put("gateway", smsGateGroup.getGeteway());
                }
            }
            log.info("send sms to mobile:{},params:{}", mobile, params);
            response = GSXService.doService(controller, action, params);
            log.info("params:{}, response:{}", params, response);
        } catch (Exception e) {
            response = new RestfulResult<>();
            response.setCode(1);
            response.setData(null);
            response.setMsg("发送短信失败");
            log.error("sendSms exception - ", e);
        }
        return response;
    }

    public static boolean sendSms(String mobile, String content, Integer messageType, Integer userId,
        Integer userRole) {
        return sendSms(mobile, content, messageType, userId, userRole, false);
    }

}
