
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.image;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import javax.imageio.ImageIO;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

import com.google.common.base.Preconditions;

/**
 * @title ImageUtils
 * @desc TODO
 * @author cxm
 * @date 2016年2月26日
 * @version 1.0
 */
public class OrgQrImageUtils {

    private static final int DEFAULT_IMAGE_WIDTH = 880;

    private static final int DEFAULT_IMAGE_HEIGHT = 320;

    private static final String ORG_400_HOTLINE = "4000-122-166";

    private static final String IMG_HOTLINE_FORMAT = "%s 转 %s";

    public static Image getImageFromUrl(String url) throws IOException {
        Preconditions.checkArgument(StringUtils.isNoneBlank(url), "image url can not be null");
        URL imageUrl = new URL(url);
        InputStream in = null;
        try {
            in = imageUrl.openStream();
            return ImageIO.read(in);
        } finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static Image readImageFromFile(String fileName) throws IOException {
        Preconditions.checkArgument(StringUtils.isNoneBlank(fileName), "image file name can not be null");
        File imgFile = new File(fileName);
        if (!imgFile.exists()) {
            throw new FileNotFoundException(fileName + " is not exist");
        }
        return ImageIO.read(imgFile);
    }

    public static Image loadImage(String fileName) throws IOException {
        Preconditions.checkArgument(StringUtils.isNoneBlank(fileName), "image file name can not be null");
        InputStream in = null;
        try {
            in = OrgQrImageUtils.class.getClassLoader().getResourceAsStream(fileName);
            Preconditions.checkNotNull(in, "can not read file:" + fileName);
            return ImageIO.read(in);
        } finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static void main(String[] args) throws IOException {
        BufferedImage img = generateOrgQrFingerPrintImg("机构名称", "http://test-img.gsxservice.com/429623_wvy1l1ie.jpg",
            "3888888", "weixin");

        File file = new File("/Users/cxm/Downloads/image.jpg");
        ImageIO.write(img, "png", file);
    }

    public static BufferedImage generateOrgQrFingerPrintImg(String orgName, String qrUrl, String extension,
        String weixin) throws IOException {
        Preconditions.checkArgument(StringUtils.isNoneBlank(orgName), "orgName can not be null");
        Preconditions.checkArgument(StringUtils.isNoneBlank(qrUrl), "qrUrl can not be null");
        //Preconditions.checkArgument(StringUtils.isNoneBlank(extension), "extension can not be null");
        Preconditions.checkArgument(StringUtils.isNoneBlank(weixin), "weixin can not be null");
        
        String telStr = "";
        if(extension!=null){
        	telStr = String.format(IMG_HOTLINE_FORMAT, ORG_400_HOTLINE, extension);
        }
        
        String weixinStr = "微信号: " + weixin;

        Image qrImg = getImageFromUrl(qrUrl);

        Image telImg = loadImage("img/phone_icon.png");
        Image fpImg = loadImage("img/zhiwen.png");

        Font font = new Font("微软雅黑", Font.PLAIN, 25);
        BufferedImage bi =
            new BufferedImage(DEFAULT_IMAGE_WIDTH, DEFAULT_IMAGE_HEIGHT, BufferedImage.TYPE_USHORT_565_RGB);
        Graphics2D g2 = (Graphics2D) bi.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);

        g2.setBackground(Color.WHITE);

        g2.fillRect(0, 0, DEFAULT_IMAGE_WIDTH, DEFAULT_IMAGE_HEIGHT);
        g2.drawImage(qrImg, 72, 20, 280, 280, null);
        g2.setPaint(Color.BLACK);
        g2.setFont(font);

        FontRenderContext context = g2.getFontRenderContext();
        Rectangle2D bounds = font.getStringBounds(telStr, context);
        double x = 72 + DEFAULT_IMAGE_HEIGHT + 10;
        double y = DEFAULT_IMAGE_HEIGHT / 3;
        double ascent = -bounds.getY();
        double baseY = y + ascent;

        g2.drawImage(telImg, (int) x, (int) baseY / 2 + 77, 30, 30, null);

        g2.drawString(telStr, (int) x + 40, (int) baseY / 2 + 100);
        Font nameFont = new Font("微软雅黑", Font.PLAIN, 23);
        g2.drawString(orgName, (int) x, (int) baseY / 2);
        g2.setFont(nameFont);
        g2.setColor(Color.gray);
        g2.drawString(weixinStr, (int) x, (int) baseY / 2 + 50);

        g2.drawImage(fpImg, (int) x, DEFAULT_IMAGE_HEIGHT - 100, 390, 60, null);

        return bi;

    }
}
