
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */
    
package com.baijia.tianxiao.enums;

import com.baijia.tianxiao.dto.UniverseErrorCode;


public enum SignupErrorCode implements UniverseErrorCode {
    
    UNKNOW(ErrorSide.UNKNOW, Subsystem.UNKNOW, Platform.UNKNOW, 1 ,"未知类型错误"), 
    PURCHASE_NOT_SUCCEED(8001, "获取订单失败，稍后再试。"),
    PURCHASEID_ERROR(8002, "报名单号不存在或者与报名类型不符"), // 业务逻辑错误
    COURCE_CHANGE(8003, "已拆分的课程不能修改"), // 业务逻辑错误
    REPEAT_SUBMIT(8004, "报名已经完成，不能重复报名"), // 业务逻辑错误
    TOTALPRICE_ERROR(8005, "课程总价不能为负"), // 业务逻辑错误
    TOTALPRICE_NOTMATCH(8006, "所选课程总价与支付订单总价不符，请重新选择所有课程"), // 业务逻辑错误
    UNKNOWN_PURCHASE_STATUS(8007, "未知的报名类型"), // 业务逻辑错误
    REGISTER_FAILED(8008, "浅注册失败"), // 业务逻辑错误
    SIGNUPCOURSE_NULL(8009, "报名单未选择课程"), // 业务逻辑错误
    MOBILE_FORMATE_ERROR(8010, "手机号码格式错误"), PURCHASE_ID_INVALIDATE(8011, "订单不存在,请检查订单ID"),
    PURCHASE_ID_ALREADY_PAY_SUCC(8012, "订单已经支付完成,不需要再次支付"),
    SIGNUP_HAS_NOT_COURSE_INFO(8013, "报名单还没有课程信息,请先填写报名信息."),
    SEND_SMS_COUNT_TOO_SOON(8014, "已达到今天发送短信上限,请明天再试"),
    SIGNUP_SMS_KEY_INVALIDATE(8015, "无法找到订单,请重新发送短信"),
    SPLITPURCHASE_ERROR(8016, "拆分订单失败"), // 交互错误
    GETTRADENO_ERROR(8017, "获取交易流水号失败"), // 交互错误
    STUDENT_NOT_REGISTERD(8018, "学员不在花名册中"), // 交互错误
    ;
    
    private ErrorSide errorSide;
    private Subsystem subsystem;
    private Platform platform;
    private int code;
    private String message;
    
    private SignupErrorCode(ErrorSide errorSide, Subsystem subsystem, Platform platform, int code, String msg){
        this.errorSide = errorSide;
        this.subsystem = subsystem;
        this.platform = platform;
        this.code = code;
        this.message = msg;
    }
    
    private SignupErrorCode(int code, String msg) {
        this(ErrorSide.SERVER, Subsystem.SIGNUP, Platform.UNKNOW, code, msg);
    }
    
    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getErrorSide()
     */
    @Override
    public ErrorSide getErrorSide() {
        return errorSide;
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getSystem()
     */
    @Override
    public Subsystem getSystem() {
        return subsystem;
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getPlatform()
     */
    @Override
    public Platform getPlatform() {
        return platform;
    }

    @Override
    public int getSubsystemErrorCode(){
        return code;
    }
    
    @Override
    public String getMessage(){
        return message;
    }
    
    @Override
    public SignupErrorCode fromCode(int code){
        for (SignupErrorCode errorCode:values()){
            if (errorCode.getSubsystemErrorCode()==code){
                return errorCode;
            }
        }
        return UNKNOW;
    }
}

    