package com.baijia.tianxiao.enums;

import java.util.Map;

import com.google.common.collect.Maps;

public enum ModifyStatus {

    NORMAL(0, "正常"),
    
    UPDATE(1, "修改"),
    
    ADDED(2, "增加"),
    
    DELETE(3, "删除");
    
    private int value;
    
    private String label;
    
    private static Map<Integer, ModifyStatus> cache;
    
    static {
        cache = Maps.newHashMap();
        cache.put(NORMAL.getValue(), NORMAL);
        cache.put(UPDATE.getValue(), UPDATE);
        cache.put(ADDED.getValue(), ADDED);
        cache.put(DELETE.getValue(), DELETE);
    }
    
    private ModifyStatus(int value, String label){
        this.value = value;
        this.label = label;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
    
    public static ModifyStatus get(int value) {
        if (cache.containsKey(value)) {
            return cache.get(value);
        }
        return null;
    }
    
    public static boolean containsKey(int value) {
        return cache.containsKey(value);
    }
}
