
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dto.msg;

import java.util.Map;

import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.constants.sms.SmsMessageType;

import lombok.Data;

/**
 * @title SendMsgRequest
 * @desc TODO
 * @author cxm
 * @date 2016年3月19日
 * @version 1.0
 */
@Data
public class SendMsgRequest {

    /**
     * 公众号的appid,预留
     */
    private String appId;

    private Long orgId;

    /**
     * 微信模板ID 具体ID查看WechateTemplateMsgType的数字
     */
    private Integer wechatTemplateId;

    /**
     * 短信内容,如果不发短信,将短信内容设置为空即可
     */
    private String smsContent;

    /**
     * 发送人的ID
     */
    private Long senderId;

    private UserRoleEnum senderRole;

    private Long receiverId;

    private UserRoleEnum receiverRole;

    private String mobile;

    /**
     * 微信的openId
     */
    private String weixinOpenId;

    /**
     * 发送短信时是否进行计数,默认短信都开启计数.
     */
    private boolean countSms = true;

    /**
     * 默认短信走天校通知通道
     */
    private SmsMessageType smsMsgType = SmsMessageType.TIANXIAO_NOTIFY;

    /**
     * 发送微信消息的参数
     */
    private Map<String, Object> wechatParams;

    // /**
    // * 如果微信和短信模板同时存在,先发送微信,微信发送是吧再发送短信
    // */
    // private boolean wechatFirst = true;

}
