/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.constants.signup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.google.common.collect.Maps;

/**
 * @author cxm
 * @version 1.0
 * @title PayType
 * @desc TODO
 * @date 2015年9月8日
 */
public enum PayType {

    PAY_POS_CARD(0, "POS支付"),

    BALANCE(1, "余额"),
    /**
     * 0 POS机刷卡, 1 POS机微信 2 POS机支付宝 3 在线支付, 4 现金
     */
    ALIPAY_POS(2, "支付宝"), // yunying.org_signup_info.pay_type

    CASH(4, "现金支付"), // yunying.org_signup_info.pay_type

    PAY_OB(3, "网银"),

    PAY_WEI_XIN1(5, "微信"),

    PAY_WEI_XIN2(50, "微信"), // 对应支付那边的4

    PAY_CFT(6, "财付通"),

    PAY_KQ_KJ(7, "快钱快捷支付"),

    PAY_YL(8, "银联支付"),

    PAY_YHQ(9, "优惠券"),

    PAY_ELSE(10, "其他金额"),

    PAY_KJ(11, "快捷支付"),

    PAY_KQ(12, "快钱"),

    TOTAL_BALANCE(21, "余额全量支付"),
    TOTAL_FAV_CODE(22, "全量优惠码支付"),
    MIX_BALANCE_FAV(23, "混合余额 +优惠码支付"),

    PAY_KQ_OB(24, "快钱网银支付"),

    BAIDU_PAY(25, "BAIDU_PAY"),

    PAY_BDZD(26, "百度直达号支付"),

    PAY_POS_YINLIAN_CARD(27, "银联POS支付"), // yunying.org_signup_info.pay_type

    PAY_POS_KUAIQIAN_CARD(28, "快钱POS支付"), // yunying.org_signup_info.pay_type

    WX_POS(30, "微信扫码支付"), // yunying.org_signup_info.pay_type

    APPSTORE_PAY(32, "苹果支付"),
    STUDYCOIN_PAY(33, "苹果渠道学币支付"),
    WX_POS_TX(35, "微信扫码支付"),//天校微信扫码
    LKL_POS(40, "拉卡拉POS机支付"),
    ONLINE_PAYMENT(51, "在线支付"),;

    private int code;

    private String note;

    private static Map<Integer, PayType> map = Maps.newHashMap();

    private PayType(int code, String note) {
        this.code = code;
        this.note = note;
    }

    static {
        for (PayType payType : PayType.values()) {
            map.put(payType.code, payType);
        }
    }

    public static List<Integer> getAllCode() {
        return new ArrayList<Integer>(map.keySet());
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static PayType getPayTypeByCode(Integer code) {
        return map.get(code);
    }

    public static PayType getPayTypeByTypeStr(String payTypeStr) {
        if (StringUtils.isBlank(payTypeStr)) {
            return PayType.ONLINE_PAYMENT;
        }

        try {
            int tempPayType = Integer.parseInt(payTypeStr);
            PayType payType = getPayTypeByCode(tempPayType);
            if (payType == null) {
                return PayType.ONLINE_PAYMENT;
            }
            return payType;
        } catch (Exception e) {
            //考虑直接是paytype 的情况
        }

        String[] payTypes = payTypeStr.split("_");

        String[] payTypeDetailStr = payTypes[0].split(":");
        if (payTypeDetailStr.length != 2) {
            return PayType.ONLINE_PAYMENT;
        }
        Integer typeValue = Integer.parseInt(payTypeDetailStr[0]);
        if (typeValue == 4) {
            return PAY_WEI_XIN2;
        }
        PayType payType = getPayTypeByCode(typeValue);
        if (payType == null) {
            return PayType.ONLINE_PAYMENT;
        }
        return payType;
    }

    /**
     * pos支付\现金支付\在线支付三类
     *
     * @param payTypeStr
     * @return
     */
    public static String getNameByPayType(String payTypeStr) {
        PayType result = getPayTypeByTypeStr(payTypeStr);
        if (result == PAY_POS_YINLIAN_CARD || result == PAY_POS_KUAIQIAN_CARD) {
            return PAY_POS_CARD.getNote();
        }

        if (result != PAY_POS_CARD && result != CASH) {
            return ONLINE_PAYMENT.getNote();
        }
        return result.getNote();
    }

    /**
     * pos支付\现金支付\在线支付三类
     *
     * @param payTypeStr
     * @return
     */
    public static int getCodeByPayType(String payTypeStr) {
        PayType result = getPayTypeByTypeStr(payTypeStr);
        if (result == PAY_POS_YINLIAN_CARD || result == PAY_POS_KUAIQIAN_CARD) {
            return PAY_POS_CARD.getCode();
        }

        if (result != PAY_POS_CARD && result != CASH) {
            return ONLINE_PAYMENT.getCode();
        }
        return result.getCode();
    }

    /**
     * pos支付\现金支付\在线支付三类
     *
     * @param payTypeCode
     * @return
     */
    public static int getCodeByPayType(int payTypeCode) {
        PayType result = getPayTypeByCode(payTypeCode);
        if (result == PAY_POS_YINLIAN_CARD || result == PAY_POS_KUAIQIAN_CARD) {
            return PAY_POS_CARD.getCode();
        }

        if (result != PAY_POS_CARD && result != CASH) {
            return ONLINE_PAYMENT.getCode();
        }
        return result.getCode();
    }

    public static String getByCode(int code) {
        int payCode = getCodeByPayType(code);
        return getPayTypeByCode(payCode).getNote();
    }

    public static void main(String[] args) {
        System.out.println(PayType.getCodeByPayType("28:0.01"));
    }
}
