
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.util;

import org.apache.commons.lang3.StringUtils;

import java.util.Random;

 /**
 * @title ValidateUtil
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年12月22日
 * @version 1.0
 */

public class ValidateUtil {

    private static String regpw = "^[^\\s]{6,16}$";
    private static String regEmail = "^(\\w)+(\\.\\w+)*@(\\w)+((\\.\\w{2,3}){1,3})$";
    private static String regIdCard = "(^\\d{15}$)|(^\\d{17}([0-9]|X)$)";

    
    private static String regMobile = "^[1][1,2,3,4,5,6,7,8,9][0-9]{9}$";
    
    private static String regPw = "^[a-zA-Z]\\w{5,17}$";
    
    private static String regPw2 = "^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{8,16}$"; 
    
    
    public static boolean isMobileAllowed(String mobile){
        if(StringUtils.isNotBlank(mobile)){
            return mobile.matches(regMobile);
        }
        return false;
    }
    
    
    public static boolean isEmailAllowed(String email){
        if(StringUtils.isNotBlank(email)){
            return email.matches(regEmail);
        }
        return false;
    }
    
    
    public static boolean isIdCardAllowed(String idCard){
        if(StringUtils.isNotBlank(idCard)){
            return idCard.matches(regIdCard);
        }
        return false;
    }
    
    public static boolean isPwAllowed(String pwd){
        if(StringUtils.isNotBlank(pwd)){
            return pwd.matches(regPw2);
        }
        return false;
    }

     /**
      * 生成字母(大写、小写、大小写混合)、数字
      * @param length 生成长度
      * @param isCapital : null大小写混合;TRUE仅大写;FALSE仅小写
      * @param needNumer : 是否要数字
      * @return
      */
    public static String getRandom(int length, Boolean isCapital, boolean needNumer) {
        String result = "";
        if (length > 0) {
            Random random = new Random();
            for (int i = 0; i < length; i++) {
                boolean isChar = (needNumer ? random.nextInt(2) % 2 == 0 : true);
                if (isChar) {
                    int begin;
                    if (isCapital != null) {
                        begin = isCapital ? 'A' : 'a';
                    } else {
                        begin = random.nextInt(2) % 2 == 0 ? 'A' : 'a';
                    }
                    result += (char)(random.nextInt(26) + begin);
                } else {
                    result += String.valueOf(random.nextInt(10));
                }
            }
        }
        return result;
    }
    
    public static void main(String[] args) {
        String pws = "1234abcd";
        System.out.println(pws.matches(regPw2));
        System.out.println(getRandom(8, true, true));
        System.out.println(getRandom(8, false, true));
        System.out.println(getRandom(8, null, true));
        System.out.println(getRandom(8, true, false));
        System.out.println(getRandom(8, false, false));
        System.out.println(getRandom(8, null, false));
        //System.out.println(pws.matches("^[a-zA-Z]\\w{5,17}$"));
        
    }
}

    