
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.WxBizSchedule;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.wx.api.WxBizScheduleService;
import com.baijia.tianxiao.sal.wx.api.WxStudentCourseService;
import com.baijia.tianxiao.sal.wx.api.WxTaskService;
import com.baijia.tianxiao.sal.wx.enums.BizScheduleType;

import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @title WxTaskServiceImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年1月24日
 * @version 1.0
 */

@Slf4j
@Service
public class WxTaskServiceImpl implements WxTaskService {

    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    
    @Resource
    private OrgLessonSignService orgLessonSignService;
    
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    
    @Resource
    private CourseStudentService courseStudentService;
    
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    
    @Resource
    private OrgStudentDao orgStudentDao;
    
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    
    @Resource
    private WxBizScheduleService wxBizScheduleService;
    
    @Resource
    private WxStudentCourseService wxStudentCourseService;
    
    
    @Override
    public void doScheduleExcute(){
        Date now = new Date();
        List<WxBizSchedule> list = wxBizScheduleService.queryByScheduleTimeAndStatus(now, 1);
        for(WxBizSchedule schedule:list){
            doWxBizScheduleBiz(schedule);
        }
    }
    
    private void doWxBizScheduleBiz(WxBizSchedule schedule){
        int code = schedule.getBizType();
        BizScheduleType type = BizScheduleType.getByCode(code);
        if(type==null){
            log.warn("doWxBizScheduleBiz fail bizTypeCode not exit code:{}",code);
            return;
        }
        try {
            if (type == BizScheduleType.course_delay_sign) {
                wxBizScheduleService.excuteBizSchedule(type, schedule.getBizKey());
                wxStudentCourseService.doStudentLessonAndSignByOrgStudentCourseId(schedule.getBizKey(),true);
            } 
            wxBizScheduleService.finishBizSchedule(type, schedule.getBizKey());
        } catch (Exception e) {
            log.warn("doWxBizScheduleBiz fail bizTypeCode not exit ",e);
            wxBizScheduleService.failBizSchedule(type, schedule.getBizKey());
        }
        
    }

}

    