
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.WxCommonCounterDao;
import com.baijia.tianxiao.dal.org.po.WxCommonCounter;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.wx.api.WxCommonCounterService;
import com.baijia.tianxiao.sal.wx.model.WxCommonCounterKey;

import com.google.common.collect.Maps;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

/**
 * @title WxCommonCounterServiceImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年2月3日
 * @version 1.0
 */

@Service("wxCommonCounterService")
public class WxCommonCounterServiceImpl implements WxCommonCounterService {

    @Resource
    private WxCommonCounterDao wxCommonCounterDao;
    
    @Override
    public boolean create(WxCommonCounter record) {
        boolean bool = checkKeyAvailable(record.getMainKey(),record.getSecondaryKey());
        if(bool == false){
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR,"计数器的key不合法");
        }
        try {
            wxCommonCounterDao.save(record);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    
    @Override
    public boolean addOne(WxCommonCounterKey commonCounterKey) {
        
        if(0==wxCommonCounterDao.addOne(commonCounterKey.getMainKey(), commonCounterKey.getSecondaryKey())){
            WxCommonCounter commonCounter = new WxCommonCounter();
            commonCounter.setMainKey(commonCounterKey.getMainKey());
            commonCounter.setSecondaryKey(commonCounterKey.getSecondaryKey());
            commonCounter.setValue(0L);
            this.create(commonCounter);
        }else{
            return true;
        }
        return 1==wxCommonCounterDao.addOne(commonCounterKey.getMainKey(), commonCounterKey.getSecondaryKey());
    }
    
    @Override
    public boolean subOne(WxCommonCounterKey commonCounterKey) {
        return 1==wxCommonCounterDao.subOne(commonCounterKey.getMainKey(), commonCounterKey.getSecondaryKey());
    }
    

    @Override
    public boolean addOneForMaxValue(WxCommonCounterKey commonCounterKey,
            Long maxValue) {
        return 1==wxCommonCounterDao.addOneForMaxValue(commonCounterKey.getMainKey(), commonCounterKey.getSecondaryKey(), maxValue);
    }


    @Override
    public boolean exist(WxCommonCounterKey commonCounterKey) {
        WxCommonCounter commonCounter = wxCommonCounterDao.getByKey(commonCounterKey.getMainKey(), commonCounterKey.getSecondaryKey());
        return commonCounter!=null;
    }
    
    @Override
    public Long getCurrentCountByKey(WxCommonCounterKey commonCounterKey) {
        WxCommonCounter commonCounter = wxCommonCounterDao.getByKey(commonCounterKey.getMainKey(), commonCounterKey.getSecondaryKey());
        if(commonCounter==null){
            return 0L;
        }
        return commonCounter.getValue();
    }
    
    @Override
    public List<WxCommonCounter> getListByKeys(String mainKey,Collection<String> secondaryKeys) {
        return wxCommonCounterDao.getListBySecondekeys(mainKey,secondaryKeys);
    }
    
    @Override
    public Map<String,Long> getMapByKeys(String mainKey,Collection<String> secondaryKeys) {
        return wxCommonCounterDao.getMapBySecondekeys(mainKey,secondaryKeys);
    }

    private boolean checkKeyAvailable(String mainKey,String secondaryKey){
        if(StringUtils.isBlank(mainKey)||StringUtils.isBlank(secondaryKey)){
            return false;
        }
        return true;
    }



    @Override
    public Map<String,Long> getListByMainKey(String mainKey) {
        Map<String,Long> map = Maps.newHashMap();
        List<WxCommonCounter> list = wxCommonCounterDao.getListByMainKey(mainKey);
        if(CollectionUtils.isNotEmpty(list)){
            for(WxCommonCounter counter:list){
                map.put(counter.getSecondaryKey(), counter.getValue());
            }
        }
        return map;
    }

}

    