
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.WxBizScheduleDao;
import com.baijia.tianxiao.dal.org.po.WxBizSchedule;
import com.baijia.tianxiao.sal.wx.api.WxBizScheduleService;
import com.baijia.tianxiao.sal.wx.enums.BizScheduleType;

import com.google.common.collect.Maps;

import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

/**
 * @title WxBizScheduleServiceImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年1月24日
 * @version 1.0
 */

@Service("wxBizScheduleService")
public class WxBizScheduleServiceImpl implements WxBizScheduleService{

    @Resource
    private WxBizScheduleDao wxBizScheduleDao;
    
    
    @Override
    public void saveSchedule(BizScheduleType bizType, Long bizKey, Date scheduleTime) {
        
        WxBizSchedule bizSchedule = new WxBizSchedule();
        bizSchedule.setBizType(bizType.getCode());
        bizSchedule.setBizKey(bizKey);
        bizSchedule.setScheduleTime(scheduleTime);
        bizSchedule.setStatus(1);
        
        wxBizScheduleDao.save(bizSchedule);
            
    }

    @Override
    public void updateScheduleStatus(BizScheduleType bizType, Long bizKey, Integer status) {
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("bizType", bizType.getCode());
        condition.put("bizKey",bizKey);
        condition.put("status", status);
        wxBizScheduleDao.update(condition, "status");
            
    }

    @Override
    public boolean excuteBizSchedule(BizScheduleType bizType, Long bizKey) {
        
        return 1==wxBizScheduleDao.updateForChangeStatusByBizTypeAndKey(bizType.getCode(), bizKey, 1, 2);
            
    }

    @Override
    public boolean finishBizSchedule(BizScheduleType bizType, Long bizKey) {
        
        return 1==wxBizScheduleDao.updateForChangeStatusByBizTypeAndKey(bizType.getCode(), bizKey, 2, 3);
            
    }

    @Override
    public boolean failBizSchedule(BizScheduleType bizType, Long bizKey) {
        
        return 1==wxBizScheduleDao.updateForChangeStatusByBizTypeAndKey(bizType.getCode(), bizKey, 2, 0);
            
    }

    @Override
    public List<WxBizSchedule> queryByScheduleTimeAndStatus(Date scheduleTime, Integer status) {
        
        return wxBizScheduleDao.queryByScheduleTimeAndStatus(scheduleTime, status);
            
    }

   
    
   
}

    