
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.commons.cache.CacheUtil;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.msg.service.CommonSmsService;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.student.util.OrgStudentUtil;
import com.baijia.tianxiao.sal.wx.api.RegisterService;
import com.baijia.tianxiao.sal.wx.api.ValidateCodeService;
import com.baijia.tianxiao.sal.wx.api.WxOrgStudentService;
import com.baijia.tianxiao.sal.wx.model.CodeSendTimesForCache;
import com.baijia.tianxiao.sal.wx.model.ValidateCodeSend;
import com.baijia.tianxiao.sal.wx.model.ValidateCodeSend.BizTypeEnum;
import com.baijia.tianxiao.sal.wx.model.ValidateCodeSend.SendSMSTypeEnum;
import com.baijia.tianxiao.sal.wx.model.ValidateCodeSend.SendTypeEnum;
import com.baijia.tianxiao.sal.wx.result.CommonDataResult;
import com.baijia.tianxiao.sal.wx.result.ValidateCodeSendResult;
import com.baijia.tianxiao.sal.wx.util.ValidateUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;

 /**
 * @title RegiesterServiceImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年12月22日
 * @version 1.0
 */

@Slf4j
@Service("registerService")
public class RegisterServiceImpl implements RegisterService {

    @Resource
    private CommonSmsService smsService;
    @Resource
    private ValidateCodeService validateCodeSendService;
    @Resource
    private WxOrgStudentService wxOrgStudentService;
    @Resource
    private OrgAccountService orgAccountService;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgInfoDao orgInfoDao;

    
    /**
     * 发送手机验证码
     */
    @Override
    public CommonDataResult<?> sendSMSCode(Long orgId,String mobileNum, String key,
            BizTypeEnum type, int codeType) {
        
        CommonDataResult<?> result = new CommonDataResult(true);
        
        if(!ValidateUtil.isMobileAllowed(mobileNum)){
            result.setSuccess(false);
            result.setMsg("手机号不合法");
            return result;
        }
        
        
        
        OrgAccount account = orgAccountService.getOrgAccountById(orgId.intValue());
        if(account == null){
            result.setSuccess(false);
            result.setMsg("无效机构");
            return result;
        }
        CommonDataResult<?> checkResult = wxOrgStudentService
                .checkMobileExist(orgId,mobileNum, StringUtils.EMPTY, codeType);
        if (!checkResult.isSuccess()) {
            result.setSuccess(false);
            result.setMsg(checkResult.getMsg());
            return result;
        }
        Date now  = new Date();
        key += orgId+"_"+mobileNum;
        CodeSendTimesForCache codeSendTimes = (CodeSendTimesForCache) CacheUtil.getValue(key);
        //为空或者不是当天新建对象
        if(codeSendTimes==null||!DateUtil.isSameDay(codeSendTimes.getLastSendTime(),now)){
            codeSendTimes = new CodeSendTimesForCache();
            codeSendTimes.setIdentifyingCode(mobileNum);
            codeSendTimes.setSendTimes(0);
            codeSendTimes.setLastSendTime(now);
            codeSendTimes.setCreateTime(now);
            
        }else {
            //次数上线为到就++，到了就返回错误码
            if(CodeSendTimesForCache.MAXSENDTIMESONEDAY >codeSendTimes.getSendTimes()){
                codeSendTimes.setSendTimes(codeSendTimes.getSendTimes() + 1);
                codeSendTimes.setLastSendTime(Calendar.getInstance().getTime());
            }else{
                result.setSuccess(false);
                result.setMsg("每天只能发送"+CodeSendTimesForCache.MAXSENDTIMESONEDAY+"次");
                return result;
            }           
        }
                
        ValidateCodeSend validateCodeSend = new ValidateCodeSend();
        validateCodeSend.setSendIdentity(mobileNum);
        validateCodeSend.setSendType(SendTypeEnum.SMS);
        validateCodeSend.setBizType(type);
        validateCodeSend.setEffectMinute(15);
        ValidateCodeSendResult checkCodeResult = validateCodeSendService
                .createAndSendCheckCode(validateCodeSend,false);
        if(checkCodeResult.isSuccess()){
            String checkCode = checkCodeResult.getCheckCode();
            
            String smsContent = String.format(type.getContent(),account.getUserName());
            smsContent = smsContent.replaceFirst("\\$\\{checkCode\\}",checkCode);
            smsService.sendSms(orgId, UserRoleEnum.ORG.getCode(), Long.valueOf(mobileNum), UserRoleEnum.STUDENT.getCode(), mobileNum, SmsMessageType.CODE, smsContent); 
            Date todayEndTime = DateUtil.getEndOfDay(now);
            Long expire  = (todayEndTime.getTime() - now.getTime())/1000;
            if(expire<60){
                expire = 60l;
            }
            //验证码发送成功，更新发送次数到缓存
            CacheUtil.set(key, codeSendTimes, expire);
            return result;
        }
        
        result.setSuccess(false);
        return result;
    }
    
    
    @Override
    public CommonDataResult<?> checkSMSCode(Long orgId,String mobilephone, String code,
            BizTypeEnum bizType) {
        CommonDataResult<?> result = new CommonDataResult<String>(true);
        ValidateCodeSend validateCodeSend = new ValidateCodeSend();
        validateCodeSend.setSendIdentity(mobilephone);
        //validateCodeSend.setSendType(SendTypeEnum.SMS);
        validateCodeSend.setBizType(bizType);
        ValidateCodeSendResult valResult = validateCodeSendService.check(
                validateCodeSend, code);
        if (!valResult.isSuccess()) {
            result.setSuccess(false);
            result.setMsg(valResult.getMsg());
          
        } else {
            result.setSuccess(true);
        }
        return result;
    }
    
    @Override
    public CommonDataResult<OrgStudent> createStudentForWxRegiester(Long orgId, String mobile,String nickName, String inputPwd) {
        CommonDataResult<OrgStudent> result = new CommonDataResult<OrgStudent>(false);
        if(!ValidateUtil.isPwAllowed(inputPwd)){
            result.setMsg("密码不合法，必须以字母开头，6～18位密码，只能包含字母数字和下划线");
            return result;
        }
        int codeType = SendSMSTypeEnum.REGISTER.getIndex();
        CommonDataResult<?> checkMobileResult = wxOrgStudentService
            .checkMobileExist(orgId,mobile, StringUtils.EMPTY, codeType);
        if(checkMobileResult.isSuccess() == false){
            result.setMsg(checkMobileResult.getMsg());
            return result;
        }
        Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(nickName);
        Long userId = userInfoMap.get("id");
        OrgStudent orgStudent = new OrgStudent();
        orgStudent.setOrgId(orgId);
        orgStudent.setUserId(userId);
        orgStudent.setMobile(mobile);
        orgStudent.setName(nickName);
        orgStudent.setNickName(nickName);
        orgStudent.setDelStatus(0);
        orgStudent.setPwd(PasswordUtil.createHash(inputPwd));
        orgStudentDao.save(orgStudent);
        
        result.setSuccess(true);
        result.setData(orgStudent);
        return result;
    }
    
    @Override
    public CommonDataResult<OrgStudent> checkAndResetStudentPwd(Long orgId, String mobile,String inputPwd,String inputPwd2) {
        CommonDataResult<OrgStudent> result = new CommonDataResult<OrgStudent>(false);
        if(!ValidateUtil.isPwAllowed(inputPwd)){
            result.setMsg("密码不合法，必须以字母和数字的组合，长度8到16位");
            return result;
        }
        if(!StringUtils.equals(inputPwd, inputPwd2)){
            result.setMsg("两次密码不一样");
            return result;
        }
        int codeType = SendSMSTypeEnum.FIND_PASSWORD.getIndex();
        
        OrgStudent orgStudent = this.orgStudentDao.getLastStudentByMobileOrParentMobile(orgId, mobile);
        orgStudent.setPwd(PasswordUtil.createHash(inputPwd));
        orgStudentDao.update(orgStudent,"pwd");
        
        result.setSuccess(true);
        result.setData(orgStudent);
        return result;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public boolean sendStudentPwd(Long orgId, Long userId) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(userId != null && userId > 0, "userId is illegal");
        String orgName = this.orgInfoDao.getOrgShortNameByOrgId(orgId.intValue());
        OrgStudent orgStudent = this.orgStudentDao.getStudent(orgId, userId, DeleteStatus.NORMAL.getValue());
        if (orgStudent == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生未不存在或已被删除");
        }
        // 生成8位随机密码:小写字母+数字
        String password = ValidateUtil.getRandom(8, false, true);
        orgStudent.setPwd(PasswordUtil.createHash(password));
        orgStudent.setUpdateTime(new Date());
        this.orgStudentDao.updateWithDefaultVal(orgStudent, "pwd", "updateTime");

        String smsContent = String.format(BizTypeEnum.SmsRandomPassword.getContent(), orgName, orgStudent.getMobile(), password);
        boolean isSuccess = smsService.sendSms(orgId, UserRoleEnum.ORG.getCode(), Long.valueOf(orgStudent.getMobile()), UserRoleEnum.STUDENT.getCode(), orgStudent.getMobile(), SmsMessageType.CODE, smsContent);
        return isSuccess;
    }
}

    