package com.baijia.tianxiao.sal.wx.config;
import java.util.Properties;

import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

import com.baijia.tianxiao.util.properties.PropertiesReader;

import lombok.extern.slf4j.Slf4j;
/**
 * redis配置
 * Created by wangsixia on 2017/1/17.
 */
//@Configuration
@Slf4j
public class RedisConfig {
    private JedisConnectionFactory createJedisConnectionFactory(){
        JedisConnectionFactory factory = new JedisConnectionFactory();
        return factory;
    }
    // 支付授权redis
//    @Bean(name="payRedisTemplate")
    public RedisTemplate<String, String> createRedisTemplate(){
        JedisConnectionFactory factory = createJedisConnectionFactory();
        Properties properties = PropertiesReader.fillProperties("pay-redis");
        factory.setHostName(properties.getProperty("pay.redis.host"));
        factory.setPort(Integer.parseInt(properties.getProperty("pay.redis.port")));
        factory.setDatabase(Integer.parseInt(properties.getProperty("pay.redis.default.db")));
        factory.setPassword(properties.getProperty("pay.redis.pass"));
        factory.setTimeout(Integer.parseInt(properties.getProperty("pay.redis.timeout")));
        factory.afterPropertiesSet();
        return new StringRedisTemplate(factory);
    }
}