
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.api;

import com.baijia.tianxiao.dal.org.dto.WxCloudSourceDto;
import com.baijia.tianxiao.dal.org.po.WxCloudSource;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @title WxCloudSourceService
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年1月9日
 * @version 1.0
 */

public interface WxCloudSourceService {

    public void create(WxCloudSource wxCloudSource);
    
    public Map<String,Object> createVideoSourceUploadUrl(Long orgId,Integer operatorId,String name,String tags,String info);
    
    public Map<String,Object> getResumeVideoSourceUploadUrl(Long orgId, Long id);
    
    public boolean updateById(WxCloudSource wxCloudSource);
    
    public boolean updateForbidden(Long orgId,Long id, Integer isForbidden);
    
    public boolean updateVisible(Long orgId,Long id, Integer visible);
    
    public boolean deleteById(Long orgId,Long id);
    
    public boolean updateStatusAndSize(WxCloudSource orgCloudSource);
    
    public boolean updateStatusAndSizeByCloudId(WxCloudSource orgCloudSource);
    
    public boolean updateCloudInfoByCloudId(WxCloudSource orgCloudSource);
    
    public boolean updateCustomInfo(WxCloudSource orgCloudSource);
    
    public WxCloudSource getByCloudId(Integer bizType,Long cloudId);
    
    public WxCloudSource getById(Long orgId,Long id);
    
    public Map<Long,WxCloudSource> getMapByIds(Long orgId,Collection<Long> ids);
    
    public List<WxCloudSource> listByDtoCondition(WxCloudSourceDto dto,PageDto pageDto);
    
    public String getVideoSign(Long orgId,Long id);
    
    public Long getOrgTotalSize(Long orgId);
    
    
}

    