
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.model;

import com.baijia.tianxiao.sal.teacher.dto.OrgTeacherResponseDto;

import java.util.Date;

import lombok.Data;

/**
 * @title WxVideoLessonView
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年1月9日
 * @version 1.0
 */

@Data
public class WxLiveLessonView {

    private Long orgId;
    
    private Long lessonId;
    
    private Integer number;
    
    private String name;
    
    private Long courseId;
    
    private String courseName;
    
    private String coverUrl;
    
    private String teacherName;
    
    private String adminName;
    
    private OrgTeacherResponseDto teacher;
    
    private Long teacherId;
    
    private OrgTeacherResponseDto admin;
    
    private Long adminId;
    
    private Date createTime;
    
    private Date updateTime;
    
    private Integer delStatus;
    
    private Long roomId;    //直播房间id
    
    private Date startTime; 
    
    private Date endTime;
    
    
    private Integer studentCount;
    
    private Integer roomStatus;
    
    /**
     * 直播类型
     */
        
    private Integer type;
    
    /**
     * 教务登录码
     */
        
    private String adminCode;
    
    /**
     * 老师登录码
     */
        
    private String teacherCode;
    
    private Integer backLength;
    
    private Integer playBack;
    
    private Long backSize;
    
    /**
     * 回放创建时间
     */
        
    private Date backCreateTime;
    
    /**
     * 回放有效截止时间
     */
        
    private Date backEndTime;
    
    /**
     * 直播时间，结束时间减去开始时间
     */
        
    public Long getLength(){
        return (endTime.getTime()-startTime.getTime())/60000l;
    }
    
    
}

    