package com.baijia.tianxiao.sal.wx.model;

import lombok.Data;

import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.sal.course.dto.response.OrgCourseGroupDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.util.BaseUtils;

import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.List;

/**
 * 网校课程信息
 * Created by wangsixia on 2017/1/19.
 */
@Data
public class WxCourseInfoDto {

    // 课程id
    private Long courseId;
    // 课程名称
    private String courseName;
    // 价格
    private Double coursePrice; 
    // 封面
    private String coverUrl;
    // 封面图片的存储id
    private Integer coverStorageId;
    // 课程类型
    private Integer courseType;
    // 课程资料数
    private Integer wareCount;
    // 已上课次
    private Integer finishCount = 0;
    // 已排课次
    private Integer rangeCount = 0;
    // 班级学员信息
    //private List<WxUserInfo> studentInfos;
    // 报名时间
    private Date signupTime;
    // 到期时间
    private Date expireTime;
    // 已报学生数
    private Integer studentNum = 0;
    // 最大学生数
    private Integer maxStudent;
    
    private Integer freq;
    
    private String introduction;
    
    private Integer status;
    
    private List<TeacherResponseDto> teacherResponseDtos;
    
    private List<Long> teacherIds = null;// 课程老师
    
    private List<String> teacherNames = null;// 课程老师
    
    
    private List<Integer> groupIds = null;//分类id
    
    private List<String> groupNames = null;//分类名字
    
    
    //可退款天数
    private Integer refundDays;
    
    //有效天数
    private Integer effectDays;
    
    private Boolean allLessonEnd = true;
    
    public String getCoverUrl() {
        return StringUtils.isBlank(this.coverUrl) ? TianXiaoConstant.DEFAULT_CLASS_DETAIL_COVER : this.coverUrl;
    }
    
    
    
}
