
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseExtra;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseLessonService;
import com.baijia.tianxiao.sal.wx.api.OrgCourseExtraService;
import com.baijia.tianxiao.sal.wx.api.WxBizScheduleService;
import com.baijia.tianxiao.sal.wx.api.WxCommonCounterService;
import com.baijia.tianxiao.sal.wx.api.WxStudentCourseService;
import com.baijia.tianxiao.sal.wx.enums.BizScheduleType;
import com.baijia.tianxiao.sal.wx.model.WxCommonCounterKey;
import com.baijia.tianxiao.sal.wx.model.WxCourseStudentInfo;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.date.DateUtil;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @title WxStudentCourseServiceImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年2月5日
 * @version 1.0
 */

@Slf4j
@Service("wxStudentCourseService")
public class WxStudentCourseServiceImpl implements WxStudentCourseService{

    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    
    @Autowired
    private OrgStudentDao orgStudentDao;
    
    @Autowired
    private OrgStudentApiService orgStudentApiService;
    
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    
    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;
    
    @Resource
    private WxBizScheduleService wxBizScheduleService;
    
    @Resource
    private OrgCourseExtraService orgCourseExtraService;
    
    @Resource
    private OrgSignupCourseLessonService orgSignupCourseLessonService;
    @Resource
    private WxCommonCounterService wxCommonCounterService;
    
    
    @Override
    public List<WxCourseStudentInfo> queryPageStudentsByCourseId(Long orgId, Long courseId, PageDto pageDto) {
        
        List<WxCourseStudentInfo> studentInfos = new ArrayList<>();
        List<OrgStudentCourse> list = this.orgStudentCourseDao.getStudentListByCourseId(orgId, courseId, pageDto);
        if (CollectionUtils.isNotEmpty(list)) {
            Map<Long,OrgStudentCourse> mapStudentCourse = Maps.newHashMap();
            for(OrgStudentCourse studentCourse:list){
                mapStudentCourse.put(studentCourse.getUserId(), studentCourse);
            }
            List<OrgStudent> students = this.orgStudentDao.getWxListByParam(orgId, null, mapStudentCourse.keySet(), null, null, null, null, null);
            if (CollectionUtils.isNotEmpty(students)) {
                Map<Long, String> avatarMap = this.orgStudentApiService.batchGetStudentAvatarUrl(students);
                for (OrgStudent orgStudent : students) {
                    WxCourseStudentInfo dto = new WxCourseStudentInfo();
                    dto.setStudentId(orgStudent.getId());
                    dto.setUserId(orgStudent.getUserId());
                    dto.setName(orgStudent.getName());
                    dto.setMobile(orgStudent.getMobile());
                    dto.setCreateTime(orgStudent.getCreateTime());
                    dto.setCoverId(orgStudent.getAvatar());
                    dto.setCoverUrl(avatarMap.get(orgStudent.getId()));
                    
                    OrgStudentCourse studentCourse = mapStudentCourse.get(orgStudent.getUserId());
                    dto.setRecordId(studentCourse.getId());
                    dto.setCreateTime(studentCourse.getCreateTime());
                    studentInfos.add(dto);
                }
            }
        }
        
        return studentInfos;
            
    }

    @Override
    public List<WxCourseStudentInfo> queryPageStudentsByCourseIdAndMaxId(Long orgId, Long courseId, Integer pageSize,
        Long maxId) {
        
        List<WxCourseStudentInfo> studentInfos = new ArrayList<>();
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("courseId",courseId);
        
        List<OrgStudentCourse> list = this.orgStudentCourseDao.getPageByCourseIdAndMaxId(orgId,courseId,pageSize,maxId);
        
        if (CollectionUtils.isNotEmpty(list)) {
            //Set<Long> userIds = Sets.newHashSet();
            Map<Long,OrgStudentCourse> mapStudentCourse = Maps.newHashMap();
            for(OrgStudentCourse studentCourse:list){
                mapStudentCourse.put(studentCourse.getUserId(), studentCourse);
            }
            List<OrgStudent> students = this.orgStudentDao.getWxListByParam(orgId, null, mapStudentCourse.keySet(), null, null, null, null, null);
            if (CollectionUtils.isNotEmpty(students)) {
                Map<Long, String> avatarMap = this.orgStudentApiService.batchGetStudentAvatarUrl(students);
                for (OrgStudent orgStudent : students) {
                    WxCourseStudentInfo dto = new WxCourseStudentInfo();
                    dto.setStudentId(orgStudent.getId());
                    dto.setUserId(orgStudent.getUserId());
                    dto.setName(orgStudent.getName());
                    dto.setMobile(orgStudent.getMobile());
                    dto.setStudentCreateTime(orgStudent.getCreateTime());
                    dto.setCoverId(orgStudent.getAvatar());
                    dto.setCoverUrl(avatarMap.get(orgStudent.getId()));
                    
                    OrgStudentCourse studentCourse = mapStudentCourse.get(orgStudent.getUserId());
                    dto.setRecordId(studentCourse.getId());
                    dto.setCreateTime(studentCourse.getCreateTime());
                    
                    studentInfos.add(dto);
                }
            }
        }
        
        return studentInfos;
            
    }
    
    @Override
    public void doStudentLessonAndSignByOrgStudentCourseId(Long orgStudentCourseId,boolean needSign) {

        OrgStudentCourse studentCourse = orgStudentCourseDao.getById(orgStudentCourseId);
        
        if(studentCourse==null){
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "班级学员不存在");
        }
        
//        if(studentCourse.getTradeComplete()!=1){
//            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "班级学员交易状态错误");
//        }
        
        if(studentCourse.getStatus()!=0){
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "班级学员状态错误，已经退班");
        }
        
        if(studentCourse.getDelStatus()!=0){
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "班级学员已经删除");
        }
        Long orgId = studentCourse.getOrgId();
        Long courseId = studentCourse.getCourseId();
        Long studentUserId = studentCourse.getUserId();
        OrgStudent orgStudent = orgStudentDao.getStudent(orgId, studentUserId, DeleteStatus.NORMAL.getValue());
        if(orgStudent == null){
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "班级学员已经删除");
        }
        List<Long> courseIds = Lists.newArrayList();
        courseIds.add(courseId);
        List<OrgClassLesson> lessonList = orgClassLessonDao.getLessonByCourseIds(courseIds, DeleteStatus.NORMAL.getValue());
       /* List<Long> lessonIds = Lists.newArrayList();
        Map<Long,>
        for(OrgClassLesson lesson:lessonList){
            if(lesson.getDelStatus()==0 ){
                Long lessonId = lesson.getId();
                lessonIds.add(lessonId);
            }
            
        }*/
        List<Long> lessonIds = Lists.newArrayList();
        List<OrgStudentLesson> saveStudentLessons = Lists.newArrayList();
        OrgStudentLesson po = null;
        for (OrgClassLesson lesson : lessonList) {
            lessonIds.add(lesson.getId());
            po = new OrgStudentLesson();
            po.setLessonId(lesson.getId());
            po.setOrgId(orgId);
            po.setUserId(studentUserId);
            po.setCourseId(courseId);
            po.setStartStatus(1);
            
            Long mi = (lesson.getEndTime().getTime()-lesson.getStartTime().getTime())/60/1000l;
            po.setLessonDuration(mi.intValue());
            
            saveStudentLessons.add(po);
        }
        
        log.info("save students :{} to lessonids:{}", saveStudentLessons, lessonIds);
        if(CollectionUtils.isNotEmpty(saveStudentLessons)){
            orgSignupCourseLessonService.saveSignupCourseLessons(orgId, courseId, saveStudentLessons);
            orgStudentLessonDao.saveAll(saveStudentLessons);
        }
        
        if(!needSign){
            return;
        }
        List<OrgLessonSign> newSignStudents = Lists.newArrayList();
        for (Long lessonId : lessonIds) {

            OrgLessonSign lessonSign = new OrgLessonSign();
            lessonSign.setCourseId(courseId);
            lessonSign.setCreateTime(new Date());
            lessonSign.setLessonId(lessonId);
            lessonSign.setOrgId(orgId);
            lessonSign.setStatus(1);
            lessonSign.setUserId(studentUserId);
            lessonSign.setUpdateTime(new Date());
            lessonSign.setUserRole(UserRole.STUDENT.getRole());
            newSignStudents.add(lessonSign);
            
        }
        
        orgLessonSignDao.saveAll(newSignStudents,false, "courseId", "createTime", "lessonId", "orgId", "status", "userId",
            "updateTime", "userRole");
        
    }

    @Override
    public void doWxStudentLesson(OrgCourse orgCourse, OrgStudentCourse orgStudentCourse) {
        
        if(orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode()){
            this.doStudentLessonAndSignByOrgStudentCourseId(orgStudentCourse.getId(), false);
        }
        else if(orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode()){
            List<Long> courseIds = Lists.newArrayList();
            courseIds.add(orgCourse.getId());
            Map<Long,OrgCourseExtra> map = orgCourseExtraService.queryMapByCourseIds(courseIds);
            OrgCourseExtra orgCourseExtra = map.get(orgCourse.getId());
            //默认当天支付算课消，查询课程设置的延迟付款的时间
            Integer refundDays = null;
            //避免脏数据，一场数据，默认给0
            if(orgCourseExtra==null||orgCourseExtra.getRefundDays()==null || orgCourseExtra.getRefundDays()<=0){
                log.warn("OrgCourseExtra null course id={}",orgCourse.getId());
                refundDays = 0;
            }else{
                refundDays = orgCourseExtra.getRefundDays();
            }
           
            Date date = DateUtil.addDay(new Date(), refundDays);
            this.wxBizScheduleService.saveSchedule(BizScheduleType.course_delay_sign, orgStudentCourse.getId(), date);
        }
    }


    @Override
    public void taskProcess(OrgCourse orgCourse, OrgStudentCourse orgStudentCourse) {
        this.courseOrderCounter(orgCourse.getId());
        this.doWxStudentLesson(orgCourse, orgStudentCourse);
    }

    /**
     * 支付成功后,课程订单数+1
     * @param courseId
     */
    private void courseOrderCounter(Long courseId) {
        WxCommonCounterKey wxCommonCounterKey = new WxCommonCounterKey();
        wxCommonCounterKey.setMainKey(WxCommonCounterKey.MainKeyType.course_order_count.name());
        wxCommonCounterKey.setSecondaryKey(courseId + "");
        this.wxCommonCounterService.addOne(wxCommonCounterKey);
    }
}

    