
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.WxLiveRoomDao;
import com.baijia.tianxiao.dal.org.dto.WxLiveRoomQueryDto;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.WxLiveRoom;
import com.baijia.tianxiao.dal.org.po.WxLiveRoomRecord;
import com.baijia.tianxiao.sal.cloud.api.LiveRoomApi;
import com.baijia.tianxiao.sal.course.dto.OrgCourseQueryResponseDto;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.teacher.api.OrgTeacherService;
import com.baijia.tianxiao.sal.teacher.api.TeacherService;
import com.baijia.tianxiao.sal.teacher.dto.OrgTeacherResponseDto;
import com.baijia.tianxiao.sal.wx.api.WxCourseService;
import com.baijia.tianxiao.sal.wx.api.WxLiveRoomRecordService;
import com.baijia.tianxiao.sal.wx.api.WxLiveRoomService;
import com.baijia.tianxiao.sal.wx.api.WxRoomUserCountService;
import com.baijia.tianxiao.sal.wx.model.WxLiveLessonView;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.date.DateUtil;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.Resource;

/**
 * @title WxLiveRoomServiceImpl
 * @desc TODO
 * @author leiruiqi
 * @date 2017年1月10日
 * @version 1.0
 */

@Service("wxLiveRoomService")
public class WxLiveRoomServiceImpl implements WxLiveRoomService {

    @Resource
    private WxLiveRoomDao wxLiveRoomDao;

    @Resource
    private WxCourseService wxCourseService;

    @Resource
    private LiveRoomApi liveRoomApi;

    @Resource
    private WxLiveRoomRecordService wxLiveRoomRecordService;

    @Resource
    private WxRoomUserCountService wxRoomUserCountService;

    @Resource
    private OrgStudentCourseService orgStudentCourseService;

    @Resource
    private OrgTeacherService orgTeacherService;

    @Resource
    private TeacherService teacherService;

    @Resource
    private OrgClassLessonDao orgClassLessonDao;

    @Override
    public Long getLessonRoomId(Long orgId, Long lessonId) {

        Map<String, Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonId);

        List<WxLiveRoom> list = wxLiveRoomDao.queryByCondition(condition, null);

        if (list.size() == 0) {
            return null;
        }

        return list.get(0).getRoomId();

    }

    @Override
    public WxLiveRoom getByRoomId(Long roomId) {
        return this.wxLiveRoomDao.getByRoomId(roomId);

    }

    @Override
    public WxLiveRoom getLessonRoom(Long orgId, Long lessonId) {

        Map<String, Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonId);

        List<WxLiveRoom> list = wxLiveRoomDao.queryByCondition(condition, null);

        if (list.size() == 0) {
            return null;
        }

        return list.get(0);

    }

    @Override
    public Map<Long, WxLiveRoom> queryMapByOrgLessonIds(Long orgId, Collection<Long> lessonIds) {

        List<WxLiveRoom> list = queryListByOrgLessonIds(orgId, lessonIds);

        Map<Long, WxLiveRoom> map = Maps.newHashMap();

        for (WxLiveRoom room : list) {
            map.put(room.getLessonId(), room);
        }

        return map;
    }

    @Override
    public List<WxLiveRoom> queryListByOrgLessonIds(Long orgId, Collection<Long> lessonIds) {

        Map<String, Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonIds);

        List<WxLiveRoom> list = wxLiveRoomDao.queryByCondition(condition, null);

        return list;
    }

    @Override
    public void save(WxLiveRoom wxLiveRoom) {

        wxLiveRoomDao.save(wxLiveRoom);

    }

    @Override
    public void update(WxLiveRoom wxLiveRoom) {

        wxLiveRoomDao.update(wxLiveRoom);

    }

    @Override
    public void delete(Long orgId, Long lessonId) {

        Map<String, Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonId);

        this.wxLiveRoomDao.delByCondition(condition);

    }

    @Override
    public List<WxLiveRoom> queryByConditon(WxLiveRoomQueryDto dto, PageDto pageDto) {

        List<WxLiveRoom> list = wxLiveRoomDao.queryByConditon(dto, pageDto);

        return list;
    }

    @Override
    public List<WxLiveLessonView> buildLessonLiveView(Long orgId, List<WxLiveRoom> list) {
        List<WxLiveLessonView> viewList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return viewList;
        }
        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> userIds = Sets.newHashSet();
        Set<Long> lessonIds = Sets.newHashSet();
        for (WxLiveRoom room : list) {
            courseIds.add(room.getCourseId());
            lessonIds.add(room.getLessonId());
            if (room.getAdminId() != null && room.getAdminId() > 0) {
                userIds.add(room.getAdminId());
            }

            if (room.getTeacherId() != null && room.getTeacherId() > 0) {
                userIds.add(room.getTeacherId());
            }

        }
        List<OrgClassLesson> lessonList = Lists.newArrayList();

        if (CollectionUtils.isNotEmpty(lessonIds)) {
            Map<String, Object> condition = Maps.newHashMap();
            condition.put("orgId", orgId);
            condition.put("id", lessonIds);
            condition.put("dalStatus", 0);
            lessonList = orgClassLessonDao.queryByCondition(condition, null);
        }
        Map<Long, OrgClassLesson> lessonMap = Maps.newHashMap();
        for (OrgClassLesson lesson : lessonList) {
            lessonMap.put(lesson.getId(), lesson);
        }

        Map<Long, OrgTeacherResponseDto> teacherMaps = teacherService.getOrgTeacherMap(orgId, userIds);
        /*
         * List<OrgTeacherInfoDto> teacherList = TeacherService.listByOrgTeacherIds(orgId,
         * Lists.newArrayList(teacherIds)); Map<Long,OrgTeacherInfoDto> teacherMaps = Maps.newHashMap();
         * for(OrgTeacherInfoDto teacher:teacherList){ teacherMaps.put(teacher.getUserId(), teacher); }
         */

        List<OrgCourseQueryResponseDto> courseList =
            wxCourseService.buildOrgCourseByCourseIds(orgId, Lists.newArrayList(courseIds));
        Map<Long, OrgCourseQueryResponseDto> courseMap = Maps.newHashMap();

        for (OrgCourseQueryResponseDto dto : courseList) {
            courseMap.put(dto.getOrgCourseId(), dto);
        }
        ArrayListMultimap<Long, Long> courseStudentIdMap =
            orgStudentCourseService.getClassStudentIdMap(orgId, Lists.newArrayList(courseMap.keySet()));

        Date now = new Date();
        for (WxLiveRoom room : list) {
            Long courseId = room.getCourseId();
            OrgCourseQueryResponseDto orgCourse = courseMap.get(courseId);
            Long lessonId = room.getLessonId();
            OrgClassLesson lesson = lessonMap.get(lessonId);
            if (lesson == null || orgCourse == null) {
                this.delete(orgId, lessonId);
                continue;
            }
            WxLiveLessonView view = buildWxLiveLessonView(room, lesson, orgCourse, teacherMaps, courseStudentIdMap);

            // boolean result = DateUtil.compare(view.getStartTime(),now);
            boolean result = view.getStartTime().before(now);
            if (!result) {
                view.setRoomStatus(1);
            } else {
                // if(DateUtil.compare(view.getEndTime(),now)){
                if (view.getEndTime().before(now)) {

                    view.setRoomStatus(3);
                } else {
                    view.setRoomStatus(2);
                }
            }
            viewList.add(view);
        }

        return viewList;
    }

    private WxLiveLessonView buildWxLiveLessonView(WxLiveRoom liveRoom, OrgClassLesson lesson,
        OrgCourseQueryResponseDto course, Map<Long, OrgTeacherResponseDto> teacherMaps,
        ArrayListMultimap<Long, Long> courseStudentIdMap) {
        WxLiveLessonView view = new WxLiveLessonView();
        view.setCourseId(liveRoom.getCourseId());
        view.setLessonId(liveRoom.getLessonId());
        view.setName(liveRoom.getTitle());

        view.setOrgId(liveRoom.getOrgId());

        view.setRoomId(liveRoom.getRoomId());
        view.setStartTime(liveRoom.getStartTime());
        view.setEndTime(liveRoom.getEndTime());
        view.setPlayBack(liveRoom.getPlayBack());
        view.setBackLength(liveRoom.getBackLength());

        view.setBackSize(liveRoom.getBackSize());

        view.setBackCreateTime(liveRoom.getBackTime());
        if (view.getBackCreateTime() != null) {
            Integer effectDays = course.getEffectDays();
            if (effectDays != null) {
                view.setBackEndTime(DateUtil.addDay(view.getBackCreateTime(), effectDays));
            }

        }

        view.setCourseName(course.getCourseName());
        view.setCoverUrl(course.getCoverUrl());

        view.setTeacherCode(liveRoom.getTeacherCode());
        view.setAdminCode(liveRoom.getAdminCode());

        view.setTeacherId(liveRoom.getTeacherId());
        OrgTeacherResponseDto teacher = teacherMaps.get(liveRoom.getTeacherId());

        view.setTeacher(teacher);
        if (teacher != null) {
            view.setTeacherName(teacher.getTeacherName());
        }

        view.setAdminId(liveRoom.getAdminId());
        OrgTeacherResponseDto admin = teacherMaps.get(liveRoom.getAdminId());
        view.setAdmin(admin);
        if (admin != null) {
            view.setAdminName(admin.getTeacherName());
        }

        List<Long> studengIds = courseStudentIdMap.get(liveRoom.getCourseId());
        if (CollectionUtils.isEmpty(studengIds)) {
            view.setStudentCount(0);
        } else {
            view.setStudentCount(studengIds.size());
        }

        return view;
    }

    @Override
    public void updateByLessonId(WxLiveRoom wxLiveRoom) {
        Long orgId = wxLiveRoom.getOrgId();
        Long lessonId = wxLiveRoom.getLessonId();
        List<Long> lessonIds = Lists.newArrayList();
        lessonIds.add(lessonId);
        Map<Long, WxLiveRoom> map = this.queryMapByOrgLessonIds(orgId, lessonIds);

        WxLiveRoom oldRoom = map.get(lessonId);

        wxLiveRoom.setId(oldRoom.getId());
        this.wxLiveRoomDao.update(wxLiveRoom);

    }

    public List<WxLiveRoom> queryActiveLiveRoomList() {

        return this.wxLiveRoomDao.queryActiveLiveRoomList();
    }

    public void refreshRoomUser() {
        List<WxLiveRoom> activeList = this.queryActiveLiveRoomList();
        Map<Long, Long> roomIdOrgMaps = Maps.newHashMap();
        for (WxLiveRoom room : activeList) {
            roomIdOrgMaps.put(room.getRoomId(), room.getOrgId());
        }
        if (roomIdOrgMaps.size() == 0) {
            return;
        }
        Map<String, Integer> result = liveRoomApi.getRoomsUserCount(roomIdOrgMaps.keySet());
        Date now = new Date();
        List<WxLiveRoomRecord> recordList = Lists.newArrayList();
        for (Entry<Long, Long> roomIdOrgEntry : roomIdOrgMaps.entrySet()) {

            Long roomId = roomIdOrgEntry.getKey();
            Long orgId = roomIdOrgEntry.getValue();
            String roomIdStr = String.valueOf(roomId);
            Integer count = result.get(roomIdStr);

            if (count != null) {
                WxLiveRoomRecord record = new WxLiveRoomRecord();
                record.setOrgId(orgId);
                record.setRoomId(roomId);
                record.setNum(count);
                record.setQueryTime(now);
                recordList.add(record);
            }
        }

        for (WxLiveRoomRecord record : recordList) {

            wxRoomUserCountService.updateCurrentUserCount(record.getOrgId(), record.getRoomId(),
                record.getNum().longValue());
        }

        /**
         * bugfix: 过滤num大于0的记录, 否则数据量太大, 导致慢sql
         */
        wxLiveRoomRecordService.batchSaveAyn(
            recordList.stream().filter(wxLiveRoomRecord -> wxLiveRoomRecord.getNum() > 0).collect(Collectors.toList()));

    }

    @Override
    public void updatePlaybackStatus(WxLiveRoom wxLiveRoom) {

        Map<String, Object> condition = Maps.newHashMap();
        condition.put("roomId", wxLiveRoom.getRoomId());
        condition.put("playBack", wxLiveRoom.getPlayBack());
        condition.put("backLength", wxLiveRoom.getBackLength());
        condition.put("backSize", wxLiveRoom.getBackSize());
        condition.put("backTime", wxLiveRoom.getBackTime());
        this.wxLiveRoomDao.update(condition, "playBack", "backLength", "backSize", "backTime");

    }

}
