
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.WxLiveRoomRecordDao;
import com.baijia.tianxiao.dal.org.po.WxLiveRoomRecord;
import com.baijia.tianxiao.sal.wx.api.WxLiveRoomRecordService;
import com.baijia.tianxiao.util.date.DateUtil;

import com.google.common.collect.Maps;

import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

/**
 * @title WxLiveRoomRecordServiceImpl
 * @desc TODO
 * @author leiruiqi
 * @date 2017年1月18日
 * @version 1.0
 */

@Service("wxLiveRoomRecordService")
public class WxLiveRoomRecordServiceImpl implements WxLiveRoomRecordService {

    @Resource
    private WxLiveRoomRecordDao wxLiveRoomRecordDao;

    @Override
    public void batchSave(List<WxLiveRoomRecord> list) {

        wxLiveRoomRecordDao.saveAll(list, false);

    }

    @Async
    @Override
    public void batchSaveAyn(List<WxLiveRoomRecord> list) {

        this.batchSave(list);

    }

    /**
     * 机构每日并发汇总，统计出机构历史单日的最大并发。
     */

    public void calculateDailyRecord(Date date) {

        Date startTime = DateUtil.getStartOfDay(date);
        Date endTime = DateUtil.getEndOfDay(date);
        // 先物理删除旧数据，再计算新输入入库，这样每次重跑任务可以订正数据
        wxLiveRoomRecordDao.delOrgMaxRecordByTime(startTime, endTime);
        // 按机构id分组的并发sum查询
        List<WxLiveRoomRecord> list = this.wxLiveRoomRecordDao.querySumGroupByOrg(startTime, endTime);

        Map<Long, WxLiveRoomRecord> maxNumRecordMap = Maps.newHashMap();
        for (WxLiveRoomRecord record : list) {

            WxLiveRoomRecord tempRecord = maxNumRecordMap.get(record.getOrgId());
            if (tempRecord == null) {
                maxNumRecordMap.put(record.getOrgId(), record);
                continue;
            }
            // 判断最高并发
            if (tempRecord.getNum() > tempRecord.getNum()) {
                maxNumRecordMap.put(record.getOrgId(), record);
            }

        }
        // 最高并发入库
        for (WxLiveRoomRecord record : maxNumRecordMap.values()) {
            record.setId(null);
            // roomId为空是机构并发max
            record.setRoomId(0L);
            record.setCreateTime(null);
            wxLiveRoomRecordDao.save(record);
        }
    }

    @Override
    public List<WxLiveRoomRecord> queryByOrgAndDateRange(Long orgId, Date startDate, Date endDate) {

        return wxLiveRoomRecordDao.queryDailyOrgNum(orgId, DateUtil.getStartOfDay(startDate),
            DateUtil.getEndOfDay(endDate));

    }

    // @Override
    // public WxLiveRoomRecord getOrgTodayMaxNumRecord(Long orgId) {
    //
    // return wxLiveRoomRecordDao.getOrgTodayMaxNumRecord(orgId);
    //
    // }

    @Override
    public Integer getOrgTodayMaxNum(Long orgId) {

        WxLiveRoomRecord record = wxLiveRoomRecordDao.getOrgTodayMaxNumRecord(orgId);
        if (record == null) {
            return 0;
        } else {
            return record.getNum();
        }

    }

    @Override
    public Integer getOrgMonthMaxNum(Long orgId) {

        WxLiveRoomRecord record = wxLiveRoomRecordDao.getOrgMonthMaxNumRecord(orgId);
        if (record == null) {
            return 0;
        } else {
            return record.getNum();
        }

    }

}
