
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.WxLiveRoom;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.cloud.api.LiveRoomApi;
import com.baijia.tianxiao.sal.cloud.model.request.LiveRoomCreate;
import com.baijia.tianxiao.sal.cloud.model.request.LiveRoomDelete;
import com.baijia.tianxiao.sal.cloud.model.request.LiveRoomUpdate;
import com.baijia.tianxiao.sal.cloud.model.response.DefaultApiResult;
import com.baijia.tianxiao.sal.wx.api.WxLiveRoomLessonService;
import com.baijia.tianxiao.sal.wx.api.WxLiveRoomService;
import com.baijia.tianxiao.sal.wx.model.WxCourseLessonDto;
import com.baijia.tianxiao.util.date.DateUtil;

import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @title WxLiveRoomLessonServiceImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年12月24日
 * @version 1.0
 */

@Slf4j
@Service("wxLiveRoomLessonService")
public class WxLiveRoomLessonServiceImpl implements WxLiveRoomLessonService {

    @Resource
    private LiveRoomApi liveRoomApi;
    
    @Resource
    private WxLiveRoomService wxLiveRoomService;
   
    @Override
    public DefaultApiResult create(OrgClassLesson lesson,Integer maxStudent,WxCourseLessonDto courseLessonDto) {

        LiveRoomCreate liveRoom = new LiveRoomCreate();
        liveRoom.setTitle(lesson.getName());
        liveRoom.setMax_users(maxStudent);
        liveRoom.setStart_time(DateUtil.date2UnixTimestamp(lesson.getStartTime()));
        liveRoom.setEnd_time(DateUtil.date2UnixTimestamp(lesson.getEndTime()));
        
        DefaultApiResult result;
        try {
            result = liveRoomApi.create(liveRoom);
            
        } catch (Exception e) {
            log.error("liveRoomApi.create exception:{}",e);
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "直播间api调用异常");
        }
        if(result == null){
            log.error("liveRoomApi.create fail orgId={},lessonId={},code={},msg={}",lesson.getOrgId(),lesson.getId(),result.getCode(),result.getMsg());
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "直播间api调用异常");
        }
        
        if(result.getCode() != 0){
            log.warn("liveRoomApi.create fail orgId={},lessonId={},code={},msg={}",lesson.getOrgId(),lesson.getId(),result.getCode(),result.getMsg());
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, result.getMsg());
        }
        lesson.setRoomId(Long.valueOf(result.getData().get("room_id").toString()));
        
        WxLiveRoom wxLiveRoom = lesson2LiveRoomCreate(lesson,liveRoom,result,courseLessonDto);
        wxLiveRoomService.save(wxLiveRoom);
        return result;
    }

    private WxLiveRoom lesson2LiveRoomCreate(OrgClassLesson lesson,LiveRoomCreate liveRoom,DefaultApiResult result,WxCourseLessonDto courseLessonDto){
        
        WxLiveRoom wxLiveRoom = new WxLiveRoom();
        wxLiveRoom.setOrgId(lesson.getOrgId());
        wxLiveRoom.setLessonId(lesson.getId());
        wxLiveRoom.setCourseId(lesson.getCourseId());
        wxLiveRoom.setRoomId(lesson.getRoomId());
        wxLiveRoom.setTitle(lesson.getName());
        wxLiveRoom.setType(2);
        wxLiveRoom.setStatus(0);
        wxLiveRoom.setDelStatus(0);
        
        wxLiveRoom.setStartTime(lesson.getStartTime());
        wxLiveRoom.setEndTime(lesson.getEndTime());
        wxLiveRoom.setEnterTime(new Date(lesson.getStartTime().getTime()-liveRoom.getPre_enter_time()*1000L));
        wxLiveRoom.setAdminCode(result.getData().get("admin_code").toString());
        
        wxLiveRoom.setTeacherCode(result.getData().get("teacher_code").toString());
        
        wxLiveRoom.setTeacherId(courseLessonDto.getTeacherId());
        wxLiveRoom.setAdminId(courseLessonDto.getAdminId());
        return wxLiveRoom;
    }
    
    private WxLiveRoom lesson2LiveRoomUpdate(OrgClassLesson lesson,LiveRoomCreate liveRoom,DefaultApiResult result,WxCourseLessonDto courseLessonDto){
        
        WxLiveRoom wxLiveRoom = new WxLiveRoom();
        wxLiveRoom.setOrgId(lesson.getOrgId());
        wxLiveRoom.setLessonId(lesson.getId());
        wxLiveRoom.setCourseId(lesson.getCourseId());
        wxLiveRoom.setRoomId(lesson.getRoomId());
        wxLiveRoom.setTitle(lesson.getName());
        wxLiveRoom.setType(2);
        wxLiveRoom.setStartTime(lesson.getStartTime());
        wxLiveRoom.setEndTime(lesson.getEndTime());
        wxLiveRoom.setEnterTime(new Date(lesson.getStartTime().getTime()-liveRoom.getPre_enter_time()*1000L));
        
        wxLiveRoom.setTeacherId(courseLessonDto.getTeacherId());
        wxLiveRoom.setAdminId(courseLessonDto.getAdminId());
        return wxLiveRoom;
    }
    
    @Override
    public DefaultApiResult update(OrgClassLesson lesson,Integer maxStudent,WxCourseLessonDto courseLessonDto) {
        
        LiveRoomUpdate liveRoom = new LiveRoomUpdate();
        liveRoom.setRoom_id(lesson.getRoomId().toString());
        liveRoom.setTitle(lesson.getName());
        liveRoom.setMax_users(maxStudent);
        liveRoom.setStart_time(DateUtil.date2UnixTimestamp(lesson.getStartTime()));
        liveRoom.setEnd_time(DateUtil.date2UnixTimestamp(lesson.getEndTime()));
        
        
        DefaultApiResult result;
        try {
            
            result = liveRoomApi.update(liveRoom);
            
        } catch (Exception e) {
            log.error("liveRoomApi.create exception:{}",e);
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "直播间api调用异常");
        }
        if(result == null){
            log.error("liveRoomApi.create fail orgId={},lessonId={},code={},msg={}",lesson.getOrgId(),lesson.getId(),result.getCode(),result.getMsg());
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "直播间api调用异常");
        }
        
        if(result.getCode() != 0){
            log.error("liveRoomApi.create fail orgId={},lessonId={},code={},msg={}",lesson.getOrgId(),lesson.getId(),result.getCode(),result.getMsg());
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, result.getMsg());
        }
        WxLiveRoom wxLiveRoom = lesson2LiveRoomUpdate(lesson,liveRoom,result,courseLessonDto);
        
        this.wxLiveRoomService.updateByLessonId(wxLiveRoom);
        
        return result;
    }


    @Override
    public DefaultApiResult delete(OrgClassLesson lesson) {

        LiveRoomDelete liveRoom = new LiveRoomDelete();
        liveRoom.setRoom_id(lesson.getRoomId().toString());
        
        
        DefaultApiResult result;
        try {
            result = liveRoomApi.delete(liveRoom);
            
        } catch (Exception e) {
            log.error("liveRoomApi.create exception:{}",e);
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "直播间api调用异常");
        }
        if(result == null){
            log.error("liveRoomApi.create fail orgId={},lessonId={},code={},msg={}",lesson.getOrgId(),lesson.getId(),result.getCode(),result.getMsg());
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "直播间api调用异常");
        }
      
        if(result.getCode() != 0){
            log.error("liveRoomApi.create fail orgId={},lessonId={},code={},msg={}",lesson.getOrgId(),lesson.getId(),result.getCode(),result.getMsg());
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, result.getMsg());
        }
        wxLiveRoomService.delete(lesson.getOrgId(), lesson.getId());
        return result;
    }


    @Async
    @Override
    public void asynCreate(OrgClassLesson lesson, Integer maxStudent,WxCourseLessonDto courseLessonDto) {
        asynCreate(lesson, maxStudent,courseLessonDto);
    }

    @Async
    @Override
    public void asynUpdate(OrgClassLesson lesson, Integer maxStudent,WxCourseLessonDto courseLessonDto) {
        update(lesson, maxStudent,courseLessonDto);
    }

    @Async
    @Override
    public void asynDelete(OrgClassLesson lesson) {
        delete(lesson);
    }

}

    