package com.baijia.tianxiao.sal.wx.impl;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseExtraDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.WxStudentExtDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseExtra;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.WxCloudSource;
import com.baijia.tianxiao.dal.org.po.WxLiveRoom;
import com.baijia.tianxiao.dal.org.po.WxVideoLesson;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.cloud.api.LiveRoomApi;
import com.baijia.tianxiao.sal.cloud.api.VideoApi;
import com.baijia.tianxiao.sal.cloud.model.response.DefaultApiResult;
import com.baijia.tianxiao.sal.cloud.utils.ClouldApiUtil;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.teacher.api.OrgTeacherService;
import com.baijia.tianxiao.sal.wx.api.WxCloudSourceService;
import com.baijia.tianxiao.sal.wx.api.WxConfigCacheService;
import com.baijia.tianxiao.sal.wx.api.WxLessonAccessRecordService;
import com.baijia.tianxiao.sal.wx.api.WxLessonAccessService;
import com.baijia.tianxiao.sal.wx.api.WxLiveRoomLessonService;
import com.baijia.tianxiao.sal.wx.api.WxLiveRoomService;
import com.baijia.tianxiao.sal.wx.api.WxRoomUserCountService;
import com.baijia.tianxiao.sal.wx.api.WxVideoLessonService;
import com.baijia.tianxiao.sal.wx.constant.WangxiaoConstant;
import com.baijia.tianxiao.sal.wx.model.WxLiveLessonView;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;
/**
 * @title WxLessonAccessServiceImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年12月26日
 * @version 1.0
 */
@Slf4j
@Service("wxLessonAccessService")
public class WxLessonAccessServiceImpl implements WxLessonAccessService {
    private String liveRoomEnterUrl = null;//"http://test-api.baijiacloud.com/web/room/enter?";
    
    private String playBackUrl = null;//"http://test-api.baijiacloud.com/web/playback/index?classid=";
    
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    
    @Resource
    private OrgStudentService orgStudentService;
    
    @Resource
    private OrgStudentDao orgStudentDao;
    
    @Resource
    private WxLiveRoomLessonService wxLiveRoomLessonService;
    
    @Resource
    private WxVideoLessonService wxVideoLessonService;
    
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    
    @Resource
    private OrgCourseDao orgCourseDao;
    
    @Resource
    private OrgStudentApiService orgStudentApiService;
    
    @Resource
    private WxLiveRoomService wxLiveRoomService;
    
    @Resource
    private VideoApi videoApi;
    
    @Resource
    private WxCloudSourceService wxCloudSourceService;
    
    @Resource
    private WxLessonAccessRecordService wxLessonAccessRecordService;
    
    @Resource
    private WxConfigCacheService wxConfigCacheService;
    
    @Resource
    private WxRoomUserCountService wxRoomUserCountService;
    
    @Resource
    private OrgStudentCourseService orgStudentCourceService;
    
    @Resource
    private WxStudentExtDao wxStudentExtDao;
    
    @Resource
    private OrgTeacherService orgTeacherService;
    
    @Resource
    private OrgCourseExtraDao orgCourseExtraDao;
    
    @PostConstruct
    public void init(){
        String baijiaCloudDomain = LiveRoomApi.baijiaCloudDomain;
        liveRoomEnterUrl = baijiaCloudDomain+"/web/room/enter?";
        
        
        playBackUrl = baijiaCloudDomain+"/web/playback/index?classid=";
    }
    
    @Override
    public String checkEnterClassLiveRoom(Long orgId, Long studentUserId, Long lessonId) {
        
        OrgClassLesson lesson = orgClassLessonDao.getById(lessonId);
        
        checkStudentLessonExit(orgId,studentUserId,lesson);
        OrgStudent orgStudent = orgStudentDao.getStudentByUserId(orgId, studentUserId);
        Long roomId = wxLiveRoomService.getLessonRoomId(orgId, lessonId);
        Integer maxCount = null;
        TXAccount txAccount = wxConfigCacheService.getTXAccountFromLocalCache(orgId.intValue());
        if (txAccount == null || txAccount.getConcurrentNumber() == null) {
            maxCount = WangxiaoConstant.wx_contract_concurrency;
        } else {
            maxCount = txAccount.getConcurrentNumber();
        }
        boolean canAdd = wxRoomUserCountService.addOneCurrentUserCount(orgId, roomId, maxCount.longValue());
        if (!canAdd) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "当前人数较多，已到并发上限，请稍后再试");
        }
        String enterUrl = null;
        try {
            enterUrl = createLiveRoomEnterUrl(orgStudent, roomId);
            wxLessonAccessRecordService.asyncCreate(orgId, lesson.getCourseId(), lessonId, orgStudent.getId());
        } catch (Exception e) {
            log.error("wx createLiveRoomEnterUrl error:{}", e);
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "生成房间进入链接异常");
        }
        return enterUrl;
            
    }
    
    @Override
    public String createLiveRoomPlayBackEnterUrl(Long orgId, Long studentUserId, Long lessonId) {
        
        OrgClassLesson lesson = orgClassLessonDao.getById(lessonId);
        
        checkStudentLessonExit(orgId,studentUserId,lesson);
        OrgStudent orgStudent = orgStudentDao.getStudentByUserId(orgId, studentUserId);
       // Long roomId = wxLiveRoomService.getLessonRoomId(orgId, lessonId);
        WxLiveRoom wxLiveRoom = wxLiveRoomService.getLessonRoom(orgId, lessonId);
        if(wxLiveRoom==null ||wxLiveRoom.getDelStatus()==1 ||wxLiveRoom.getPlayBack() ==0){
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "回放无效");
        }
        
        Date playBackTime = wxLiveRoom.getBackTime();
        OrgCourseExtra orgCourseExtra = orgCourseExtraDao.getByOrgCourseId(orgId, wxLiveRoom.getCourseId());
        if (orgCourseExtra != null && orgCourseExtra.getEffectDays() != null) {
            
            //Date studentCreateTime = studentCourse.getCreateTime();
            Integer effectDays = orgCourseExtra.getEffectDays();
            Date effectDate = DateUtil.addDay(playBackTime, effectDays);
            
            Date effectEndTime = DateUtil.getEndOfDay(effectDate);
            Date now = new Date();
            if(now.after(effectEndTime)){
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "您的课程已过有效期");
            }
        }
        
        
        String url = null;
        try {
            url = playBackUrl+wxLiveRoom.getRoomId();
            wxLessonAccessRecordService.asyncCreate(orgId, lesson.getCourseId(), lessonId, orgStudent.getId());
        } catch (Exception e) {
            log.error("wx createLiveRoomEnterUrl error:{}", e);
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "生成房间进入链接异常");
        }
        return url;
            
    }
    
    private void checkStudentLessonExit(Long orgId, Long studentUserId, OrgClassLesson lesson){
        
        if(lesson==null){
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "课节参数无效");
        }
        OrgCourse orgCourse = orgCourseDao.getById(lesson.getCourseId());
        
        boolean classCheckResult = (orgCourse != null && orgCourse.getIsClass().intValue()==CourseTypeEnum.IS_CLASS_TRUE.getCode());
            
        if(!classCheckResult){
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "班级参数无效");
        }
        
        
        boolean lessonCheckResult = (lesson.getOrgId().longValue() == orgId && lesson.getDelStatus() == 0);
        if (!lessonCheckResult) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "课程参数无效");
        }
        OrgStudentCourse studentCourse = orgStudentCourceService.getBySidAndCid(orgId, studentUserId, lesson.getCourseId());
        if(studentCourse==null||studentCourse.getDelStatus()!=0){
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "未获得课程资源权限");
        }
        
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode()) {
            OrgCourseExtra orgCourseExtra = orgCourseExtraDao.getByOrgCourseId(orgId, orgCourse.getId());
            if (orgCourseExtra != null && orgCourseExtra.getEffectDays() != null) {
                
                Date studentCreateTime = studentCourse.getCreateTime();
                Integer effectDays = orgCourseExtra.getEffectDays();
                Date effectDate = DateUtil.addDay(studentCreateTime, effectDays);
                
                Date effectEndTime = DateUtil.getEndOfDay(effectDate);
                Date now = new Date();
                if(now.after(effectEndTime)){
                    throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "您的课程已过有效期");
                }
            }
        }
        
        
        /*Map<String, Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lesson.getId());
        condition.put("studentId", studentUserId);
        condition.put("delStatus", 0);
        
        List<OrgStudentLesson> studentLessonList = orgStudentLessonDao.queryByCondition(condition,null);
        
        
        if(studentLessonList.size()!=1){
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "学生排课数据异常");
        }
        if(CollectionUtils.isEmpty(studentLessonList)){
            
            
            
        }*/
    }
    
    public String createLiveRoomEnterUrl(OrgStudent orgStudent,Long roomId) throws UnsupportedEncodingException{
        Collection<OrgStudent> students = Lists.newArrayList();
        students.add(orgStudent);
        Map<Long,String> studentsAvatarMap = orgStudentApiService.batchGetStudentAvatarUrl(students);
        String avatar = studentsAvatarMap.get(orgStudent.getId());
            Map<String,String> params = Maps.newHashMap();
            params.put("room_id", roomId.toString());
            params.put("user_name", orgStudent.getName());
            params.put("user_number", orgStudent.getId().toString());
            params.put("user_role", "0");
            params.put("user_avatar", avatar);
            
            ClouldApiUtil.buidlSign(params);
            String paramsUrl = ClouldApiUtil.buildUrl(params);
            String allUrl = liveRoomEnterUrl+paramsUrl;
            return allUrl;
            /*String encoderUrl = URLEncoder.encode(allUrl, "UTF-8");
            return encoderUrl;*/
    }
    
    /*public String createLiveRoomPlayBackEnterUrl(OrgStudent orgStudent,Long roomId) throws UnsupportedEncodingException{
        
        Collection<OrgStudent> students = Lists.newArrayList();
        students.add(orgStudent);
        Map<Long,String> studentsAvatarMap = orgStudentApiService.batchGetStudentAvatarUrl(students);
        String avatar = studentsAvatarMap.get(orgStudent.getId());
            Map<String,String> params = Maps.newHashMap();
            params.put("room_id", roomId.toString());
            params.put("user_name", orgStudent.getName());
            params.put("user_number", orgStudent.getId().toString());
            params.put("user_role", "0");
            params.put("user_avatar", avatar);
            
            ClouldApiUtil.buidlSign(params);
            String paramsUrl = ClouldApiUtil.buildUrl(params);
            String allUrl = liveRoomEnterUrl+paramsUrl;
            return allUrl;
            
    }*/
    
   /* public String createLiveRoomEnterUrlEncode(Long adminId,Long roomId) throws UnsupportedEncodingException{
        
        
            Map<String,Object> params = Maps.newHashMap();
            params.put("room_id", roomId);
            params.put("user_name", "admin");
            params.put("user_number", adminId);
            params.put("user_role", 2);
            params.put("user_avatar", "abc");
          
            String paramsUrl = ClouldApiUtil.buildSignAndGetUrl(params);
            String allUrl = liveRoomEnterUrl+paramsUrl;
            return createLiveRoomEnterUrl(adminId,roomId);
            return allUrl
            String encoderUrl = URLEncoder.encode(url, "UTF-8");
            return encoderUrl;
            
    }*/
    
    public String createLiveRoomEnterUrl(Long orgId,String mobile,Long roomId,boolean isAdmin) throws UnsupportedEncodingException{
        
        WxLiveRoom liveRoom = wxLiveRoomService.getByRoomId(roomId);
        
        if(liveRoom==null){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "直播房间不存在");
        }
        List<WxLiveRoom> liveRoomList = Lists.newArrayList();
        liveRoomList.add(liveRoom);
        List<WxLiveLessonView>  viewlist = wxLiveRoomService.buildLessonLiveView(orgId,liveRoomList);
        
        if(viewlist.size()==0){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "直播房间不存在");
        }
        
        WxLiveLessonView view = viewlist.get(0);
        
        
        if(view.getTeacher() !=null){
            Long userId = view.getTeacher().getUserId();
            String avatar = view.getTeacher().getAvatar();
            OrgTeacher teacher = orgTeacherService.getByUserId(userId);
            
            if(teacher!=null&&teacher.getMobile()!=null){
                if(StringUtils.equals(teacher.getMobile(), mobile)){
                    Map<String,String> params = Maps.newHashMap();
                    params.put("room_id", roomId.toString());
                    params.put("user_name", view.getTeacher().getTeacherName());
                    params.put("user_number", teacher.getId().toString());
                    params.put("user_role", "1");
                    params.put("user_avatar",avatar);
                  
                    ClouldApiUtil.buidlSign(params);
                    String paramsUrl = ClouldApiUtil.buildUrl(params);
                    String allUrl = liveRoomEnterUrl+paramsUrl;
                    return allUrl;
                }
            }
        }
        //强制以助教身份进入
        if(isAdmin){
            Long userId = view.getAdmin().getUserId();
            OrgTeacher teacher = orgTeacherService.getByUserId(userId);
            String avatar = view.getTeacher().getAvatar();
            Map<String,String> params = Maps.newHashMap();
            params.put("room_id", roomId.toString());
            params.put("user_name", view.getAdmin().getTeacherName());
            params.put("user_number", teacher.getId().toString());
            params.put("user_role", "2");
            params.put("user_avatar", avatar);
          
            ClouldApiUtil.buidlSign(params);
            String paramsUrl = ClouldApiUtil.buildUrl(params);
            String allUrl = liveRoomEnterUrl+paramsUrl;
            return allUrl;
        }
        if(view.getAdmin() !=null){
            Long userId = view.getAdmin().getUserId();
            OrgTeacher teacher = orgTeacherService.getByUserId(userId);
            String avatar = view.getTeacher().getAvatar();
            if(teacher!=null&&teacher.getMobile()!=null){
                if(StringUtils.equals(teacher.getMobile(), mobile)){
                    Map<String,String> params = Maps.newHashMap();
                    params.put("room_id", roomId.toString());
                    params.put("user_name", view.getAdmin().getTeacherName());
                    params.put("user_number", teacher.getId().toString());
                    params.put("user_role", "2");
                    params.put("user_avatar", avatar);
                  
                    ClouldApiUtil.buidlSign(params);
                    String paramsUrl = ClouldApiUtil.buildUrl(params);
                    String allUrl = liveRoomEnterUrl+paramsUrl;
                    return allUrl;
                }
            }
        }
        
        
        throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "对不起，您不是当前课程的主讲老师或者助教，无权进入");
        
        
        
}
    @Override
    public Map<String,Object> checkClassVideo(Long orgId, Long studentUserId, Long lessonId) {
        OrgClassLesson lesson = orgClassLessonDao.getById(lessonId);
        WxVideoLesson wxVideoLesson = wxVideoLessonService.getByLessonId(orgId, lessonId);
        if(wxVideoLesson == null){
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "课程不存在");
        }
        
        if (wxVideoLesson.getIsFree() == 0) {
            checkStudentLessonExit(orgId, studentUserId, lesson);
        }
        
        /*OrgCourseExtra orgCourseExtra= orgCourseExtraDao.getByOrgCourseId(orgId, lesson.getOrgId());
        
        if( orgCourseExtra!=null && orgCourseExtra.getEffectDays()!=null){
            
            Integer effectDays = orgCourseExtra.getEffectDays();
            
        }*/
        WxCloudSource cloudSource = wxCloudSourceService.getById(orgId, wxVideoLesson.getSourceId());
        if (cloudSource == null || cloudSource.getStatus() != 3 || cloudSource.getCloudId() == null) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "播放资源不存在");
        }
        if (cloudSource.getIsForbidden() == 1) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "播放资源被禁止播放");
        }
        
        String token = null;
        DefaultApiResult tokenResult = videoApi.videoPlaySign(cloudSource.getCloudId(), 180L);
//        DefaultApiResult videoInfo = videoApi.getInfo(cloudSource.getCloudId());
//        log.info("videoInfo:{}", videoInfo);
        if (tokenResult.getCode() != 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "获取文件上传地址异常");
        }
        
        OrgStudent orgStudent = orgStudentDao.getStudentByUserId(orgId, studentUserId);
        
        wxLessonAccessRecordService.asyncCreate(orgId, lesson.getCourseId(), lessonId, orgStudent.getId());
        token = tokenResult.getData().get("token").toString();
        Map<String,Object> map = Maps.newHashMap();
        map.put("token", token);
        map.put("cloudId", cloudSource.getCloudId());
        return map;
    }
}