
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.WxCloudSourceDao;
import com.baijia.tianxiao.dal.org.dao.WxFlowRecordDao;
import com.baijia.tianxiao.dal.org.po.WxCloudSource;
import com.baijia.tianxiao.dal.org.po.WxFlowRecord;
import com.baijia.tianxiao.sal.cloud.api.VideoApi;
import com.baijia.tianxiao.sal.wx.api.WxFlowRecordService;
import com.baijia.tianxiao.util.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @title WxTrafficCountRecordServiceImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年1月16日
 * @version 1.0
 */
@Slf4j
@Service("WxFlowRecordService")
public class WxFlowRecordServiceImpl implements WxFlowRecordService{

    @Resource
    private WxFlowRecordDao wxFlowRecordDao;
    
    @Resource
    private VideoApi videoApi;
    
    @Resource
    private WxCloudSourceDao wxCloudSourceDao;
    
    @Override
    public void batchSave(List<WxFlowRecord> list){
        if(CollectionUtils.isEmpty(list)){
            return;
        }
        wxFlowRecordDao.saveAll(list, false);
    }
    
    @Override
    public Long sumByOrgSourceAndDate(Long orgId,Long sourceId,Integer sourceType,String date){
        
        return wxFlowRecordDao.sumByOrgSourceAndDate(orgId, sourceId, sourceType, date);
        
    }
    
    @Override
    public Long sumByOrgSourceAndDatePrefix(Long orgId,Long sourceId,Integer sourceType,String datePrefix){
        
        Long flow = wxFlowRecordDao.sumByOrgSourceAndDatePrefix(orgId, sourceId, sourceType, datePrefix);
        if(flow == null){
            flow = 0L;
        }
        return flow;
    }

    @Override
    public Map<Long,Long> groupsumByOrgSourceAndDate(Long orgId, Long sourceId,Integer sourceType, String date,final String groupField){  
    
        return wxFlowRecordDao.groupsumByOrgSourceAndDate(orgId, sourceId, sourceType, date, groupField);
    
    }
    
    @Override
    public Map<Long,Long> groupsumByOrgSourceAndDatePrefix(Long orgId, Long sourceId,Integer sourceType, String datePrefix,String groupField){  
        
        return wxFlowRecordDao.groupsumByOrgSourceAndDatePrefix(orgId, sourceId, sourceType, datePrefix, groupField);
    
    }

    @Override
    public void synDailyVideoFlow() {
    	syncData(null);
    }
    
    public void batchSynSave(JSONArray list,Map<Long,WxFlowRecord> orgTotalFlowMap ){
        
        log.info("wx batchSynSave params,list={},orgTotalFlowMap={}",list,orgTotalFlowMap);
        Iterator<Object> it = list.iterator();
        List<Long> cloudIds = Lists.newArrayList();
        while (it.hasNext()) {
            JSONObject ob = (JSONObject) it.next();
            Long video_id = ob.getLong("video_id");
            /*String date = ob.getString("date");
            int payCount = ob.getIntValue("play_count");
            
            Long complete_count = ob.getLong("complete_count");
            Long play_length = ob.getLong("play_length");
            Long flow = ob.getLong("flow");*/
            cloudIds.add(video_id);
        }
        if(CollectionUtils.isEmpty(cloudIds)){
            return;
        }
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("cloudId", cloudIds);
        //condition.put("bizType", 1);
        List<WxCloudSource> wxCloudSourceList = wxCloudSourceDao.queryByCondition(condition, null);
        Map<Long,WxCloudSource> cloudIdMap = Maps.newHashMap();
        for(WxCloudSource cloudSource:wxCloudSourceList){
            cloudIdMap.put(cloudSource.getCloudId(), cloudSource);
        }
        log.info("wx batchSynSave params,cloudIdMap={}",cloudIdMap);
        
        List<WxFlowRecord> flowRecordSaveList = Lists.newArrayList();
        it = list.iterator();
        while (it.hasNext()) {
            JSONObject ob = (JSONObject) it.next();
            Long video_id = ob.getLong("video_id");
            String date = ob.getString("date");
            Long payCount = ob.getLong("play_count");
            
            Long complete_count = ob.getLong("complete_count");
            Long play_length = ob.getLong("play_length");
            Long flow = ob.getLong("flow");
            cloudIds.add(video_id);
            WxCloudSource cloudSource = cloudIdMap.get(video_id);
            if(cloudSource == null){
                log.info("wx batchSynSave params,cloudSource null,video_id={}",video_id);
                continue;
            }
            WxFlowRecord record = new WxFlowRecord();
            record.setOrgId(cloudSource.getOrgId());
            record.setSourceId(cloudSource.getId());
            record.setFlow(flow);
            record.setSourceType(1);
            record.setDate(date);
            record.setPlayCount(payCount);
            record.setCompleteCount(complete_count);
            record.setPlayLength(play_length);
            
            flowRecordSaveList.add(record);
            WxFlowRecord totalFlow = orgTotalFlowMap.get(cloudSource.getOrgId());
            if(totalFlow == null){
                totalFlow = new WxFlowRecord();
                totalFlow.setOrgId(cloudSource.getOrgId());
                totalFlow.setSourceType(2);
                //sourceId = org && sourceType =2 是机构总流量
                totalFlow.setSourceId(cloudSource.getOrgId());
                totalFlow.setDate(date);
                
                totalFlow.setFlow(0L);
                totalFlow.setPlayCount(0L);
                totalFlow.setCompleteCount(0L);
                totalFlow.setPlayLength(0L);
                orgTotalFlowMap.put(cloudSource.getOrgId(), totalFlow);
            }
            
            totalFlow.setFlow(totalFlow.getFlow()+flow);
            totalFlow.setPlayCount(totalFlow.getPlayCount()+payCount);
            totalFlow.setCompleteCount(totalFlow.getCompleteCount()+complete_count);
            totalFlow.setPlayLength(totalFlow.getPlayLength()+play_length);
        }
        
        log.info("wx batchSynSave params,flowRecordSaveList={}",flowRecordSaveList);
        this.batchSave(flowRecordSaveList);
        
    }

	@Override
	public void synDailyVideoFlow(String startTime, String endTime) {
		Date now = new Date();
        Date yesToday = DateUtil.addDay(now, -1);
		
		if (StringUtils.isBlank(startTime) && StringUtils.isBlank(endTime)) {
			syncData(null);
		} else {
			if (StringUtils.isNotBlank(startTime) && StringUtils.isBlank(endTime)) {
				syncData(startTime);
			} else if (StringUtils.isNotBlank(startTime) && StringUtils.isNotBlank(endTime)) {
				if (startTime.equals(endTime)) {
					syncData(startTime);
				} else {
					Date start = DateUtil.getStrToDate("yyyy-MM-dd", startTime);
			        Date end = DateUtil.getStrToDate("yyyy-MM-dd", endTime);
			        if (end.after(yesToday)) {
			        	end = yesToday;
			        }
			        
			        log.info("synDailyVideoFlow.start:{}, end:{}", start, end);
			        Long intervalDays = (end.getTime() - start.getTime()) / (24 * 3600 * 1000);
			        for (int interval = 0; interval <= intervalDays.intValue(); interval++) {
			        	Date executeDate = DateUtil.addDay(start, interval);
			        	String executeTime = DateUtil.getStrByDate(executeDate);
			        	
			        	log.info("synDailyVideoFlow.syncData.intervalDays:{},interval:{}, executeTime:{}", intervalDays, interval, executeTime);
			        	syncData(executeTime);
			        }
				}
			}
		}
		
	}
	
	void syncData(String time) {
		int page = 1;
        int pageSize = 100;
        boolean hasMore = true;
        
        if (StringUtils.isBlank(time)) {
        	Date now = new Date();
            Date yesToday = DateUtil.addDay(now, -1);
            time = DateUtil.getStrByDate(yesToday);
        }
        
        //先清除所有数据再重新计算
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("date", time);
        this.wxFlowRecordDao.delByCondition(condition);
        
        Map<Long,WxFlowRecord> orgTotalFlowMap = Maps.newHashMap();
        while(hasMore){
        	log.info("videoApi.batchQueryVideoInfo, page:{}, pageSize:{}, time:{}", page, pageSize, time);
            JSONObject apiResult = videoApi.batchQueryVideoInfo(page, pageSize, time);
            
            log.info("videoApi.batchQueryVideoInfo, result={}", apiResult);
            int code = apiResult.getInteger("code");
            if(code!=0){
                log.error("videoApi.batchQueryVideoInfo error, result={}",apiResult);
            }
            
            JSONArray list = apiResult.getJSONObject("data").getJSONArray("list");
            batchSynSave(list,orgTotalFlowMap);
            int total = apiResult.getIntValue("total");
            if(page*pageSize>=total){
                hasMore = false;
            }else{
                page++;
            }
        }
        
        log.info("wx batchSynSave params,orgTotalFlowMap={}",orgTotalFlowMap);
        this.batchSave(Lists.newArrayList(orgTotalFlowMap.values()));
	}
}

    