
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.WxFavoriteDao;
import com.baijia.tianxiao.dal.org.po.WxFavorite;
import com.baijia.tianxiao.sal.wx.api.WxFavoriteService;
import com.baijia.tianxiao.sqlbuilder.bean.Order;

import com.google.common.collect.Sets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

/**
 * @title WxFavoriteServiceImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年12月21日
 * @version 1.0
 */
@Service("wxFavoriteService")
public class WxFavoriteServiceImpl implements WxFavoriteService{

    @Resource
    private WxFavoriteDao wxFavoriteDao;

    public List<WxFavorite> listByTypesAndBizId(Long orgId, List<Integer> types, Long bizId){
        return wxFavoriteDao.listByTypesAndBizId(orgId, types, bizId);
    }


    @Override
    public List<WxFavorite> listAllByTypeAndStatus(Long orgId, Integer type,Integer status) {
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        if(type != null){
            condition.put("type",type);
        }
        
        if(status != null){
            condition.put("status",status);
        }
        
        return wxFavoriteDao.queryByCondition(condition,Order.asc("sortNo"), null);
            
    }

    @Override
    public void addNew(Long orgId, Integer type,Long bizId) {
        
        WxFavorite favorite = new WxFavorite();
        favorite.setOrgId(orgId);
        favorite.setBizId(bizId);
        favorite.setType(type);
        favorite.setSortNo(0);
        //favorite.setStatus(0);
       
        wxFavoriteDao.save(favorite);
            
    }

    @Override
    public void updateStatusAndSort(WxFavorite orgFavorite) {
        
        wxFavoriteDao.update(orgFavorite, "status","sortNo");
            
    }

    @Override
    public void delOne(Long orgId, Long id) {
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("id", id);
        
        wxFavoriteDao.delByCondition(condition);
            
    }

    @Override
    public void batchSort(Long orgId, Integer type, List<Long> ids) {
        if(CollectionUtils.isEmpty(ids)){
            return;
        }
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("type",type);
        condition.put("id", ids);
        List<WxFavorite> list =  wxFavoriteDao.queryByCondition(condition, null);
        Map<Long,WxFavorite> map = Maps.newHashMap();
        for(WxFavorite orgFavorite:list){
            map.put(orgFavorite.getId(), orgFavorite);
        }
        
        int sortNo = 0;
        for(Long id:ids){
            WxFavorite orgFavorite = map.get(id);
            if(orgFavorite!=null){
                sortNo++;
                orgFavorite.setSortNo(sortNo);
                wxFavoriteDao.update(orgFavorite, "sortNo");
            }
        }
            
    }

    @Override
    public void batchSave(Long orgId, Integer type, List<Long> ids) {
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("type",type);
        wxFavoriteDao.delByCondition(condition);
        
        List<WxFavorite> saveList = Lists.newArrayList();
        int sortNo = 0;
        Set<Long> newIds = Sets.newHashSet();
        newIds.addAll(ids);
        for(Long bizId:newIds){
            WxFavorite favorite = new WxFavorite();
            favorite.setBizId(bizId);
            favorite.setOrgId(orgId);
            favorite.setType(type);
            sortNo++;
            favorite.setSortNo(sortNo);
            saveList.add(favorite);
        }
        wxFavoriteDao.saveAll(saveList,false);
        
    }

}

    