
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.OrgCourseStatus;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dal.constant.ChargeType;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.course.dao.OrgCoursePhotoDao;
import com.baijia.tianxiao.dal.course.po.OrgCoursePhoto;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao.OrgCourseListParam;
import com.baijia.tianxiao.dal.org.dao.OrgCourseExtraDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.WxCoursewareDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseExtra;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.util.SerialNumberUtil;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.course.constant.LessonWay;
import com.baijia.tianxiao.sal.course.dto.OrgCourseInfoDto;
import com.baijia.tianxiao.sal.course.dto.OrgCourseQueryResponseDto;
import com.baijia.tianxiao.sal.course.dto.request.OrgRecommendCourseRequestDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgCourseGroupDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseConsumeRuleService;
import com.baijia.tianxiao.sal.course.service.OrgCourseGroupRelateService;
import com.baijia.tianxiao.sal.course.service.OrgCourseGroupService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService.CourseListParam;
import com.baijia.tianxiao.sal.wx.api.WxCommonCounterService;
import com.baijia.tianxiao.sal.wx.api.WxCourseService;
import com.baijia.tianxiao.sal.wx.model.WxCommonCounterKey;
import com.baijia.tianxiao.sal.wx.model.WxCourseInfoDto;
import com.baijia.tianxiao.sal.wx.model.WxCourseQueryDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.io.IOException;
import java.sql.Blob;
import java.util.*;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;

/**
 * @title WxCourseServiceImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年12月21日
 * @version 1.0
 */

@Slf4j
@Service("wxCourseService")
public class WxCourseServiceImpl implements WxCourseService {

    @Autowired
    private OrgStudentApiService orgStudentApiService;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgCourseListService orgCourseListService;
    @Autowired
    private OrgCourseGroupRelateDao orgCourseGroupRelateDao;
    @Autowired
    private WxCoursewareDao wxCoursewareDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgCourseExtraDao orgCourseExtraDao;
    @Resource
    private OrgCourseConsumeRuleService orgCourseConsumeRuleService;
    @Autowired
    private OrgCourseGroupDao orgCourseGroupDao;
    @Autowired
    private OrgCourseGroupRelateService orgCourseGroupRelateService;
    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Autowired
    private CourseTeacherService courseTeacherService;
    @Autowired
    private OrgCoursePhotoDao orgCoursePhotoDao;
    @Autowired
    private StorageDao storageDao;
    @Autowired
    private OrgCourseGroupService orgCourseGroupService;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private WxCommonCounterService wxCommonCounterService;
    
    @Override
    public List<OrgCourseQueryResponseDto> queryOrgCourses(WxCourseQueryDto courseQueryDto, PageDto pageDto) {
        List<OrgCourseQueryResponseDto> queryDtoList = new ArrayList<>();
        Long orgNumber = this.getOrgNumber(courseQueryDto.getOrgId());
        
        OrgCourseListParam param = new OrgCourseListParam();
        List<Integer> types = Lists.newArrayList();
        List<Integer> allWxCourseTypes = this.getAllWxCourseType();

        if(courseQueryDto.getCourseType()!=null){
            if(allWxCourseTypes.contains(courseQueryDto.getCourseType())){
                types.add(courseQueryDto.getCourseType());
            }else{
                types.addAll(allWxCourseTypes);
            }
        }else{
            types.addAll(allWxCourseTypes);
        }
        param.setCourseTypes(types);
        param.setPage(pageDto);
        param.setKey(courseQueryDto.getKey());
        param.setOrderField("createTime");
        param.setOrderType("DESC");
        param.setStatus(courseQueryDto.getCourseStatus());
        if(courseQueryDto.getIsFree()){
            param.setCoursePrice(0D);
        }
        // 课程分类筛选
        Collection<Long> courseIds = null;
        if (courseQueryDto.getCourseCategory() != null && courseQueryDto.getCourseCategory() > 0) {
            courseIds = this.orgCourseGroupRelateDao.getCourseIdsByGroups(Sets.newHashSet(courseQueryDto.getCourseCategory()), CourseType.ORG_COURSE.getCode());
        }
        List<OrgCourse> orgCourses = orgCourseDao.getCourseList(orgNumber, courseIds, param);
        if (CollectionUtils.isNotEmpty(orgCourses)) {
            queryDtoList  = this.buildOrgCourseByCourseList(courseQueryDto.getOrgId(), orgCourses);
        }
        return queryDtoList;
    }

    private List<OrgCourseQueryResponseDto> buildResponseDtoList(List<CourseListReponseDto> courseDtoList,Map<Long,OrgCourseExtra> courseExtraMap){
        List<OrgCourseQueryResponseDto> list = Lists.newArrayList();
        for(CourseListReponseDto course:courseDtoList){
            OrgCourseExtra extra = courseExtraMap.get(course.getOrgCourseId());
            OrgCourseQueryResponseDto queryDto = buildQueryDto(course,extra);
            list.add(queryDto);
        }
        return list;
    }
    
    private OrgCourseQueryResponseDto buildQueryDto(CourseListReponseDto course,OrgCourseExtra extra){
        
        OrgCourseQueryResponseDto dto = new OrgCourseQueryResponseDto();
        dto.setOrgCourseId(course.getOrgCourseId());
        dto.setCourseName(course.getCourseName());
        dto.setCoverUrl(course.getCoverUrl());
        dto.setOriginPrice(course.getPrice());
        dto.setCourseType(course.getCourseType());
        dto.setCourseStatus(course.getStatus());
        if(extra!=null){
            dto.setRefundDays(extra.getRefundDays());
            dto.setEffectDays(extra.getEffectDays());
        }
        
        return dto;
    }
    
    private List<Integer> getAllWxCourseType(){
        List<Integer> allWxType = Lists.newArrayList();
        allWxType.add(CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode());
        allWxType.add(CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode());
        return allWxType;
    }
    
    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), "number");
        if (account == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "机构不存在");
        }
        Integer number = account.getNumber();
        return number != null ? number.longValue() : null;
    }



    @Override
    public List<OrgCourseQueryResponseDto> buildOrgCourseByCourseIds(Long orgId,List<Long> courseIds) {
        if(CollectionUtils.isEmpty(courseIds)){
            return Lists.newArrayList();
        }
        Long orgNumber = this.getOrgNumber(orgId);
        
        OrgCourseListParam param = new OrgCourseListParam();
       
        List<Integer> types = Lists.newArrayList();
        List<Integer> allWxCourseTypes = this.getAllWxCourseType();
        
        types.addAll(allWxCourseTypes);
       
        param.setCourseTypes(types);
        
        param.setPage(null);
        List<OrgCourse> list = orgCourseDao.getCourseList(orgNumber,courseIds,param);
        return buildOrgCourseByCourseList(orgId,list);
            
    }
    
    @Override
    public Map<Long,OrgCourseQueryResponseDto> buildOrgCourseMapByCourseIds(Long orgId,List<Long> courseIds) {
        
        List<OrgCourseQueryResponseDto> list = this.buildOrgCourseByCourseIds(orgId, courseIds);
        Map<Long,OrgCourseQueryResponseDto> maps = Maps.newHashMap();
        for(OrgCourseQueryResponseDto dto:list){
            maps.put(dto.getOrgCourseId(), dto);
        }
            
        return maps;
    }
    
    @Override
    public List<OrgCourseQueryResponseDto> buildOrgCourseListMapByCourseIds(Long orgId,List<Long> courseIds) {
        
        Map<Long,OrgCourseQueryResponseDto> map = buildOrgCourseMapByCourseIds(orgId,courseIds);
            
        List<OrgCourseQueryResponseDto> list = Lists.newArrayList();
        for(Long courseId:courseIds){
            OrgCourseQueryResponseDto dto = map.get(courseId);
            if(dto!=null){
                list.add(dto);
            }
            
        }
        return list;
    }
    
    /**
     * 获取课程封面urlmap
     *
     * @param courses
     */
    public Map<Integer, String> getCoverMap(List<OrgCourse> courses) {
        Collection<Integer> coverList = CollectorUtil.collect(courses, new Function<OrgCourse, Integer>() {
            @Override
            public Integer apply(OrgCourse arg0) {
                return arg0.getCover();
            }
        });
        List<Storage> storages = this.storageDao.getByIds(coverList);
        return CollectorUtil.collectMap(storages, new Function<Storage, Integer>() {
            @Override
            public Integer apply(Storage arg0) {
                return arg0.getId().intValue();
            }
        }, new Function<Storage, String>() {
            @Override
            public String apply(Storage arg0) {
                if (StringUtils.isNotBlank(arg0.getAttach_url())) {
                    return arg0.getAttach_url();
                }
                return StorageUtil.constructUrl(arg0.getFid(), arg0.getMimetype(), arg0.getSn());
            }
        });
    }
    
    @Override
    public List<OrgCourseQueryResponseDto> buildOrgCourseByCourseList(Long orgId,List<OrgCourse> courseList) {
        
        List<OrgCourseQueryResponseDto> queryDtoList = Lists.newArrayList();
        
        CourseListParam courseListParam = new CourseListParam();
        courseListParam.setCourses(courseList).setNeedCover(true).setNeedUrl(false).setOrgId(orgId);
        
        if(CollectionUtils.isEmpty(courseList)){
            return queryDtoList;
        }
        List<CourseListReponseDto> courseDtoList = orgCourseListService.getCourseList(courseListParam);
        
        Set<Long> courseIds = Sets.newHashSet();
        for(CourseListReponseDto dto:courseDtoList){
            courseIds.add(dto.getOrgCourseId());
        }
        
        if(CollectionUtils.isEmpty(courseIds)){
            return queryDtoList;
        }
        
        Map<Long,OrgCourseExtra> courseExtraMap = this.orgCourseExtraDao.queryMapByCourseIds(courseIds);
      
        queryDtoList = buildResponseDtoList(courseDtoList,courseExtraMap);
            
        return queryDtoList;
    }

    @Override
    public WxCourseInfoDto getCourseInfo(Long orgId, Long courseId) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "机构信息错误");
        Preconditions.checkArgument(courseId != null && courseId > 0, "班级信息错误");
        WxCourseInfoDto data = new WxCourseInfoDto();
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(courseId);
        if (orgCourse == null || orgCourse.getIsDel().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课程不存在或已被删除");
        }

        //  直播课:已上课次、已排课次
        if (orgCourse.getCourseType().equals(CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode())) {
            Integer rangeCount = this.orgClassLessonDao.getLessonCount(orgId, courseId, DeleteStatus.NORMAL.getValue());
            if (rangeCount != null) {
                data.setRangeCount(rangeCount);
            }
            Map<Long, Integer> map = this.orgClassLessonDao.getWxFinishLessonCount(orgId, Lists.newArrayList(courseId), DeleteStatus.NORMAL.getValue());
            if (map != null && map.containsKey(courseId)) {
                data.setFinishCount(map.get(courseId));
            }
        }

        // 已报人数
        WxCommonCounterKey wxCommonCounterKey = new WxCommonCounterKey();
        wxCommonCounterKey.setMainKey(WxCommonCounterKey.MainKeyType.course_order_count.name());
        wxCommonCounterKey.setSecondaryKey(orgCourse.getId().toString());
        Long studentNum = this.wxCommonCounterService.getCurrentCountByKey(wxCommonCounterKey);
        data.setStudentNum(studentNum != null ? studentNum.intValue() : 0);

        /*// 班级学员
        List<WxUserInfo> studentInfos = new ArrayList<>();
        List<OrgStudentCourse> list = this.orgStudentCourseDao.getStudentListByCourseId(orgId, courseId);
        if (CollectionUtils.isNotEmpty(list)) {
            Set<Long> userIds = BaseUtils.getPropertiesList(list, "userId");
            List<OrgStudent> students = this.orgStudentDao.getWxListByParam(orgId, null, userIds, null, null, null, null, null);
            if (CollectionUtils.isNotEmpty(students)) {
                Map<Long, String> avatarMap = this.orgStudentApiService.batchGetStudentAvatarUrl(students);
                for (OrgStudent orgStudent : students) {
                    WxUserInfo dto = new WxUserInfo();
                    dto.setId(orgStudent.getId());
                    dto.setName(orgStudent.getName());
                    dto.setMobile(orgStudent.getMobile());
                    dto.setCreateTime(orgStudent.getCreateTime());
                    dto.setCoverId(orgStudent.getAvatar());
                    dto.setCoverUrl(avatarMap != null && avatarMap.containsKey(orgStudent.getAvatar()) ? avatarMap.get(orgStudent.getAvatar()) : "");
                    studentInfos.add(dto);
                }
            }
        }*/
        List<OrgCourse> courses = Lists.newArrayList();
        courses.add(orgCourse);
        Map<Integer,String> coverUrlMap = this.getCoverMap(courses);
        
        data.setCoverUrl(coverUrlMap.get(orgCourse.getCover()));

        data.setCoverStorageId(orgCourse.getCover());
        // 课程资料
        int count = this.wxCoursewareDao.getCourseWareCount(orgId, courseId);

        data.setCourseId(courseId);
        data.setCourseName(orgCourse.getName());
        data.setCourseType(orgCourse.getCourseType());
        data.setWareCount(count);
        
        data.setMaxStudent(orgCourse.getMaxStudent());
        data.setCoursePrice(orgCourse.getPrice());
        data.setFreq(orgCourse.getFreq());
        data.setStatus(orgCourse.getStatus());
        Blob source = orgCourse.getIntroduction();
        data.setIntroduction(null == source ? "" : BaseUtils.blobToString(source, "UTF-8"));
        
     // fill teacher names
        List<TeacherResponseDto> teacherResponseDtos = courseTeacherService
            .listCourseTeacher(orgId, courseId);
        List<Long> teacherIds = Lists.newArrayList();
        List<String> teacherNames = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(teacherResponseDtos)) {
            for(TeacherResponseDto teacher:teacherResponseDtos){
                teacherIds.add(teacher.getTeacherId());
                teacherNames.add(teacher.getTeacherName());
            }
        }
        data.setTeacherIds(teacherIds);
        data.setTeacherNames(teacherNames);
        data.setTeacherResponseDtos(teacherResponseDtos);
        
        List<OrgCourseGroupDto> groups = this.orgCourseGroupService.getByCourseId(orgId, courseId);
        List<Integer> groupIds = Lists.newArrayList();
        List<String> groupNames = Lists.newArrayList();
        if(CollectionUtils.isNotEmpty(groups)){
            for(OrgCourseGroupDto dto:groups){
                groupIds.add(dto.getGroupId());
                groupNames.add(dto.getGroupName());
            }
        }
        data.setGroupIds(groupIds);
        data.setGroupNames(groupNames);
        OrgCourseExtra orgCourseExtra = this.orgCourseExtraDao.getByOrgCourseId(orgId, courseId);
        if(orgCourseExtra!=null){
            data.setRefundDays(orgCourseExtra.getRefundDays());
            data.setEffectDays(orgCourseExtra.getEffectDays());
        }
        return data;
    }
    
    @Override
    @Transactional(rollbackFor = Exception.class)
    public OrgCourse saveOrUpdateCourseWxBase(Long orgId, OrgCourseInfoDto course) {
        log.info("orgId={}, course={}", orgId, course);
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId illegal.");
        Preconditions.checkArgument(course != null, "course == null");
        Preconditions.checkArgument(StringUtils.isNotBlank(course.getCourseName()), "课程名不能为空!");
        Preconditions.checkArgument(course.getCoursePrice() != null && course.getCoursePrice() >= 0, "课程价格不合法");
        

        boolean isUpdate = course.getCourseId() != null && course.getCourseId() > 0;
        if (isUpdate) {
           
        }
        OrgCourse orgCourse = new OrgCourse();
        orgCourse.setOrgNumber(this.getOrgNumber(orgId));
        orgCourse.setId(isUpdate ? course.getCourseId() : null);
        orgCourse.setBeginTime(course.getStartTime());
        orgCourse.setEndTime(course.getEndTime());
       // orgCourse.setColor(getNextRandomColor());
        

        orgCourse.setFreq(course.getFreq());
        orgCourse.setName(course.getCourseName());
        orgCourse.setMaxStudent(course.getMaxStudent());
        orgCourse.setNumber(System.nanoTime());
        orgCourse.setIsDel(course.getIsDel());
        orgCourse.setSubjectId(0);
        if (!isUpdate && course.getStatus() == null) {
            orgCourse.setStatus(OrgCourseStatus.OFFLINE.getCode());
        } else {
            orgCourse.setStatus(course.getStatus());
        }
        orgCourse.setVerifyStatus(AuditStatus.PASS.getValue());
        orgCourse.setAddress(course.getAddress());
        orgCourse.setLessonWay(LessonWay.STU_ACTIVE.getValue());
        Double lng = course.getLng();
        Double lat = course.getLat();
        if (lng != null && lat != null) {
            orgCourse.setOfflinePoi(lng + "," + lat);
        }

        orgCourse.setBranchId(-1L);
        orgCourse.setClsfyId(-1L);
        orgCourse.setRoomId(-1L);
        orgCourse.setLayoutId(-1L);
        orgCourse.setPrice(course.getCoursePrice());
        orgCourse.setLessonSummary(course.getLessonSummary());
        orgCourse.setChargeType(ChargeType.BY_PERIODS.getCode());
        if (isUpdate) {
            orgCourse.setCourseType(null);
        } else {
            Integer courseType = course.getCourseType();
            
            if (!(courseType == CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode() || courseType == CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode())) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课程类型参数错误");
            }
            
            Integer isCourse = null;
            Integer isClass = null;
            isCourse = CourseTypeEnum.IS_COURSE_TRUE.getCode();
            isClass = CourseTypeEnum.IS_CLASS_TRUE.getCode();
            
            /*if (courseType == CourseTypeEnum.COURSE_TYPE_CLASS.getCode()) {
                isCourse = CourseTypeEnum.IS_COURSE_TRUE.getCode();
                isClass = CourseTypeEnum.IS_CLASS_TRUE.getCode();
            }  else {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课程类型参数错误");
            }*/

            orgCourse.setCourseType(courseType);
            orgCourse.setIsCourse(isCourse);
            orgCourse.setIsClass(isClass);

        }

        log.debug("orgCourse={}", orgCourse);
        if (isUpdate) {
            orgCourseDao.update(orgCourse, false);
        } else {
            orgCourseDao.save(orgCourse);
        }
        

        OrgCourseExtra orgCourseExtra = new OrgCourseExtra();
        orgCourseExtra.setCourseId(orgCourse.getId());
        orgCourseExtra.setOrgId(orgId);
        orgCourseExtra.setEffectDays(course.getEffectDays());
        orgCourseExtra.setRefundDays(course.getRefundDays());
        if(isUpdate){
            Integer courseType = course.getCourseType();
            if(CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode().intValue()==courseType){
                orgCourseExtra.setEffectDays(null);
            }
            orgCourseExtraDao.updateByOrgCourseId(orgCourseExtra);
        }else{
            Integer courseType = course.getCourseType();
            if(CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode().intValue()==courseType){
                orgCourseExtra.setEffectDays(90);
            }
            orgCourseExtraDao.save(orgCourseExtra);
        }
        
        OrgCourse newCourse = orgCourseDao.getById(orgCourse.getId());
        Integer courseType = newCourse.getCourseType();
        
        
        if (isUpdate) {
            //网校课程暂时不能改变课消规则
            
        } else {
            
            Integer courseConsumeRuleValue = course.getConsumeRule();
            
            if (courseType == CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode()) {
                courseConsumeRuleValue = CourseConsumeRuleEnum.TIME_0.getValue();
            }else if(courseType == CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode()){
                courseConsumeRuleValue = CourseConsumeRuleEnum.SIGNIN_7.getValue();
            }
            
            if (orgCourse.getId() != null && orgCourse.getId() > 0) {
                this.orgCourseConsumeRuleService.create(orgId, orgCourse.getId(), courseConsumeRuleValue);
            }

        }

        if (orgCourse.getId() != null && orgCourse.getId() > 0) {
            if(!isUpdate){
                long number = SerialNumberUtil.generateNumber(orgCourse.getId().intValue(), SerialNumberUtil.COURSE_MAX, 4);
                orgCourse.setNumber(number);
                this.orgCourseDao.saveOrUpdate(orgCourse, "number");
            }


        } else {
            log.error("orgCourse={}", orgCourse);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "courseId illegal.");
        }
        
        // 课程分类
        if (StringUtils.isNotBlank(course.getGroup())) {
            List<Integer> grpIds;
            try {
                grpIds = JacksonUtil.str2List(course.getGroup(), Integer.class);
                editGroupsOfCourse(orgId, orgCourse.getId(), grpIds);
            } catch (IOException e) {
                e.printStackTrace();
                log.warn("{}", e);
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "group json format error!");
            }
        }


        return orgCourse;
    }
    
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateCourseWxOthers(Long orgId, OrgCourseInfoDto course) {
        
        OrgCourse orgCourse = orgCourseDao.getById(course.getCourseId());
        if(orgCourse == null ){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课程不存在");
        }
        Integer courseType = orgCourse.getCourseType();
        if (orgCourse != null && courseType == CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode()) {
            course.setStartTime(null);
            course.setEndTime(null);
            course.setMaxStudent(null);
            course.setFreq(null);
        }
        
        orgCourse.setCover(course.getCoverStorageId());
        if(orgCourse.getCover()!=null){
            orgCourseDao.update(orgCourse, false, "cover");
        }
        
        // edit introduction
        if (course.getIntroduction() != null) {
            Blob intro = BaseUtils.strToBlob(course.getIntroduction(), "UTF-8");
            orgCourse.setIntroduction(intro);
        }else{
            orgCourse.setIntroduction(null);
        }
        
        orgCourseDao.update(orgCourse, true, "introduction");
        
        //edit teacher
        if (StringUtils.isNotBlank(course.getTeacherIds())) {
            List<Long> teacherIds = null;
            try {
                teacherIds = JacksonUtil.str2List(course.getTeacherIds(), Long.class);
            } catch (IOException e) {
                e.printStackTrace();
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "teacherIds 参数错误！");
            }
            log.debug("{},{}", teacherIds, course.getTeacherIds());

            List<Long> courseTeachers = orgCourseTeacherDao.getTeacherIdsByCourseId(orgCourse.getId());
            if (CollectionUtils.isNotEmpty(courseTeachers)) {
                List<Long> toDelTeacherIds = findNeedDelTeacher(teacherIds, courseTeachers);
                if (toDelTeacherIds.size() > 0) {
                    int delResult = courseTeacherService.delTeacherFromCourseForLessonCheck(orgId, orgCourse.getId(),
                        toDelTeacherIds);
                    if (delResult == 0) {
                        throw new BussinessException(CommonErrorCode.PARAM_ERROR, "已经排课的老师无法删除");
                    }
                }
            }
            teacherIds.removeAll(courseTeachers);
            courseTeacherService.addTeacherToCourse(orgId, orgCourse.getId(), teacherIds);
        }

        // edit coverUrl
        if (course.getCoverStorageId() != null) {
            editCoursePhoto(orgCourse.getId(), course.getCoverStorageId().longValue());
        }
        
        return orgCourse.getId();
    }
    
    @Override
    public OrgCourseInfoDto getOrgCourseInfo(Long orgId, Long courseId) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "illegal orgId");
        Preconditions.checkArgument(courseId != null && courseId > 0, "illegal courseId");
        OrgCourseInfoDto orgCourseInfoDto = new OrgCourseInfoDto();
        //OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue(), "areaId");
        //Area area = areaDao.getById(orgInfo.getAreaId(), "name", "bname");
        // 获取百度地图对应名称
        //orgCourseInfoDto.setCityName(area.getBname());

        OrgCourse course = null;
        if (courseId != null && courseId > 0) {
            course = this.orgCourseDao.getById(courseId);
            if (course != null) {
                log.debug("---------------getNumber={},getCourseType={}", course.getNumber(), course.getCourseType());
                // 班课
                if (course.getCourseType() != CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
                    List<Long> studentIds = this.orgStudentCourseDao.getStudents(orgId, courseId, 0);
                    orgCourseInfoDto.setStudentNum(studentIds.size());
                } else {
                    List<Long> classIds = this.orgCourseDao.getClassIdsByParentId(courseId);
                    List<Long> list = this.orgStudentCourseDao.getStudentIdsByCourseIds(orgId, classIds);
                    orgCourseInfoDto.setStudentNum(list.size());
                }
                orgCourseInfoDto.setCourseType(course.getCourseType());
                orgCourseInfoDto.setCourseNumber(course.getNumber());
                orgCourseInfoDto.setCourseId(courseId);
                orgCourseInfoDto.setCourseName(course.getName());
                orgCourseInfoDto.setCoursePrice(course.getPrice());
                orgCourseInfoDto.setCoursePriceStr(NumberUtil.get2FromDouble(course.getPrice()));
                orgCourseInfoDto.setLessonSummary(course.getLessonSummary());
                //String courseUrl = environment.getProperty(RestConfig.org_class_course_url);
                //orgCourseInfoDto.setCourseUrl(courseUrl + course.getNumber());
                // 班级人数
                orgCourseInfoDto.setMaxStudent(course.getMaxStudent());
                orgCourseInfoDto.setCoverStorageId(course.getCover());
                orgCourseInfoDto.setAddress(course.getAddress());
                orgCourseInfoDto.setStartTime(course.getBeginTime());
                orgCourseInfoDto.setEndTime(course.getEndTime());
                // 计划排课次数
                orgCourseInfoDto.setFreq(course.getFreq());
                String intro = BaseUtils.blobToString(course.getIntroduction(), "UTF-8");
                orgCourseInfoDto.setIntroduction(intro);
                orgCourseInfoDto.setStatus(course.getStatus());
                orgCourseInfoDto.setIsDel(course.getIsDel());
                // 课消规则
                Integer consumeRule = orgCourseConsumeRuleService.getRuleValueByCourseId(orgId, course);
                orgCourseInfoDto.setConsumeRule(consumeRule);
                orgCourseInfoDto.setConsumeRuleStr(CourseConsumeRuleEnum.getRuleDescByValue(consumeRule));

                if (StringUtils.isNotBlank(course.getOfflinePoi())) {
                    String[] lnglat = course.getOfflinePoi().split(",");
                    log.debug("latlng={},len={}", lnglat, lnglat.length);
                    if (lnglat != null && lnglat.length >= 2) {
                        String lng = lnglat[0];
                        String lat = lnglat[1];
                        try {
                            orgCourseInfoDto.setLat(Double.parseDouble(lat));
                            orgCourseInfoDto.setLng(Double.parseDouble(lng));
                        } catch (NumberFormatException e) {
                            log.warn("lat={},lng={}", lat, lng);
                        }
                    }
                }
                orgCourseInfoDto.setCoverUrl(getCoverUrl(course));
                orgCourseInfoDto.setTeachers(this.courseTeacherService.listCourseTeacher(orgId, courseId));
                List<OrgCourseGroupDto> groups = this.orgCourseGroupService.getByCourseId(orgId, courseId);
                if (CollectionUtils.isNotEmpty(groups)) {
                    // orgCourseInfoDto.setGroup(JacksonUtil.obj2Str(groups));
                    orgCourseInfoDto.setGroups(groups);
                }

                // 根据课程id找到该课程对应所有老师的user_id
                List<Long> teacherIds = orgCourseTeacherDao.getTeacherIdsByCourseId(courseId);
                log.debug("------------------teacherIds={}", teacherIds);
                // 根据所有老师的user_id获得全部老师信息
                List<Teacher> teachers = teacherDao.getByUserIds(teacherIds);
                Map<Long, Teacher> teacherMap = Maps.newHashMap();
                if (teacherIds != null && teacherIds.size() > 0) {
                    teacherMap = CollectorUtil.collectMap(teachers, new Function<Teacher, Long>() {
                        @Override
                        public Long apply(Teacher input) {
                            return input.getUserId();
                        }
                    });
                }
                // 获得老师number,对应user表中的number
                List<Long> userIds = Lists.newArrayList();
                for (Teacher t : teachers) {
                    userIds.add(t.getUserId());
                }
                
                // 获得老师头像，copy自教师信息service
                Map<Long, Teacher> storageIds = CollectorUtil.collectMap(teachers, new Function<Teacher, Long>() {
                    @Override
                    public Long apply(Teacher teacher) {
                        return teacher.getAvatar();
                    }
                });
                List<Storage> storages = storageDao.getByIds(storageIds.keySet());
                Map<Long, Storage> storageMap = CollectorUtil.collectMap(storages, new Function<Storage, Long>() {
                    @Override
                    public Long apply(Storage storage) {
                        return storage.getId();
                    }
                });
                // 因为原课程详情里包括TeacherResponseDto,但没为其赋值，这里给他赋值
                List<TeacherResponseDto> list = Lists.newArrayList();
                for (Long l : teacherIds) {
                    TeacherResponseDto dto = new TeacherResponseDto();
                    Teacher teacher = teacherMap.get(l);
                    if (teacher.getOrgId() == null || teacher.getOrgId().longValue() != orgId.longValue()) {
                        continue;
                    }
                    if (teacher.getAvatar() != null) {
                        Storage storage = storageMap.get(teacher.getAvatar());
                        if (storage != null) {
                            String avatarUrl =
                                StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn());
                            dto.setAvatar(avatarUrl);
                        }
                    }
                    dto.setBranchId(teacher.getBranchId());
                    dto.setMobile(teacher.getMobile());
                    dto.setSchoolAge(teacher.getSchoolAge());
                    dto.setTeacherId(teacher.getUserId());
                    dto.setTeacherName(teacher.getRealName());
                    dto.setIntroduce(teacher.getIntroduce());
                    //dto.setTeacherNumber(teacherNumberMap.get(l).getNumber());
                    list.add(dto);
                }
                orgCourseInfoDto.setTeachers(list);
                // 已经安排课节
                Set<Long> set = Sets.newHashSet();
                set.add(courseId);
                Map<Long, Integer> map = orgClassLessonDao.getLessonCount(orgId, set, 0);
                int hasPlan = 0;
                if (map.get(courseId) != null) {
                    hasPlan = map.get(courseId);
                }
                orgCourseInfoDto.setHasPlan(hasPlan);
                // 开课日期和星期
                // 如果org_course表开始时间为空，去org_class_lesson取第一节课的时间
                Date date = course.getBeginTime();
                if (date != null) {
                    orgCourseInfoDto.setStartDay(DateUtil.getStrByDateFormate(date, "yyyy年MM月dd日"));
                    orgCourseInfoDto.setStartWeek("星期" + DateUtil.getChineseWeekDay(date));
                } else {
                    List<OrgClassLesson> ll =
                        orgClassLessonDao.getLessons(set, null, orgId, DeleteStatus.NORMAL.getValue());
                    if (ll != null && ll.size() > 0) {
                        OrgClassLesson o = ll.get(0);
                        orgCourseInfoDto.setStartDay(DateUtil.getStrByDateFormate(o.getStartTime(), "yyyy年MM月dd日"));
                        orgCourseInfoDto.setStartWeek("星期" + DateUtil.getChineseWeekDay(o.getStartTime()));
                    } else {
                        orgCourseInfoDto.setStartDay("");
                        orgCourseInfoDto.setStartWeek("");
                    }
                }
                orgCourseInfoDto.setIsCourse(course.getIsCourse());
                orgCourseInfoDto.setChargeType(course.getChargeType());
                
                OrgCourseExtra orgCourseExtra = this.orgCourseExtraDao.getByOrgCourseId(orgId, courseId);
                if(orgCourseExtra!=null){
                    orgCourseInfoDto.setRefundDays(orgCourseExtra.getRefundDays());
                    orgCourseInfoDto.setEffectDays(orgCourseExtra.getEffectDays());
                }
            }
        }
        return orgCourseInfoDto;
    }
    
    private void editGroupsOfCourse(Long orgId, Long courseId, List<Integer> grpIds) {
        List<Integer> orgGrpIds = this.orgCourseGroupDao.getOrgCourseGroupIdList(orgId.intValue());
        if (CollectionUtils.isEmpty(orgGrpIds) || grpIds == null || courseId == null) {
            return;
        }

        grpIds.retainAll(orgGrpIds);

        List<Integer> existGrpIds =
            orgCourseGroupRelateDao.getGroupIdByCourseId(courseId, CourseType.ORG_COURSE.getCode());
        if (CollectionUtils.isNotEmpty(existGrpIds)) {
            Collection<Integer> toDelGrpIds = Lists.newArrayList(existGrpIds);
            toDelGrpIds.removeAll(grpIds);
            orgCourseGroupRelateDao.deleteGroupOfCourse(courseId, toDelGrpIds, CourseType.ORG_COURSE.getCode());
        }

        for (Integer gid : grpIds) {
            OrgRecommendCourseRequestDto hotCourse = new OrgRecommendCourseRequestDto();
            hotCourse.setCourseId(courseId);
            hotCourse.setCourseType(CourseType.ORG_COURSE.getCode());
            orgCourseGroupRelateService.addCourse(gid, hotCourse, 0);
        }
    }
    
    private List<Long> findNeedDelTeacher(List<Long> newTeacherList, List<Long> existingTeacherList) {
        List<Long> toDelTeacherIds = Lists.newArrayList(existingTeacherList);
        toDelTeacherIds.removeAll(newTeacherList);
        return toDelTeacherIds;
    }
    
    // 兼容以前的多张图片
    private void editCoursePhoto(Long courseId, Long storageId) {
        Preconditions.checkNotNull(courseId);
        Preconditions.checkNotNull(storageId);
        String coverUrl = this.getCoverUrl(storageId);
        /*
         * boolean exist = orgCoursePhotoDao.isPhotoExist(courseId, storageId); if (!exist) {
         *
         * }
         */
        OrgCoursePhoto photo = orgCoursePhotoDao.getLastAddPhoto(courseId);
        if (photo == null) {
            photo = new OrgCoursePhoto();
        }
        photo.setCreateTime(new Date());
        photo.setOrgCourseId(courseId);
        photo.setStorageId(storageId);
        photo.setUrl(coverUrl);
        photo.setCreateTime(new Date());

        orgCoursePhotoDao.saveOrUpdate(photo);
    }
    
    private String getCoverUrl(Long storageId) {

        if (storageId == null) {
            return TianXiaoConstant.DEFAULT_CLASS_DETAIL_COVER;
        }
        Storage storage = this.storageDao.getById(storageId);
        if (storage == null) {
            return TianXiaoConstant.DEFAULT_CLASS_DETAIL_COVER;
        }
        if (StringUtils.isNotBlank(storage.getAttach_url())) {
            return storage.getAttach_url();
        }
        return StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn());
    }
    
    private String getCoverUrl(OrgCourse course) {
        if (course == null || course.getCover() == null) {
            return TianXiaoConstant.DEFAULT_CLASS_DETAIL_COVER;
        }
        return getCoverUrl(course.getCover().longValue());
    }
    
    public void editEffectDays(Long orgId,Long courseId,Integer days){
        OrgCourseExtra orgCourseExtra = new OrgCourseExtra();
        orgCourseExtra.setCourseId(courseId);
        orgCourseExtra.setOrgId(orgId);
        orgCourseExtra.setEffectDays(days);
        orgCourseExtraDao.updateByOrgCourseId(orgCourseExtra);
    }
    
}

    