
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.WxConfigDao;
import com.baijia.tianxiao.dal.org.po.WxConfig;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.wx.api.WxConfigService;
import com.baijia.tianxiao.sal.wx.enums.ConfigKeyEnum;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.annotation.Resource;

/**
 * @title OrgWxConfigServiceImpl
 * @desc 机构网校的配置都放这里了， 类型看 OrgWxConfig.ConfigKeyEnum
 * @author leiruiqi
 * @date 2016年12月28日
 * @version 1.0
 */

@Service("wxConfigService")
public class WxConfigServiceImpl implements WxConfigService {

  
    @Resource
    private WxConfigDao orgWxConfigDao;
    
    @Override
    public List<WxConfig> queryAllByOrgId(Long orgId) {
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        return orgWxConfigDao.queryByCondition(condition, null);

    }


    @Override
    public List<WxConfig> queryAllByConfigKey(ConfigKeyEnum configKey) {

        Map<String,Object> condition = Maps.newHashMap();
        condition.put("bizKey", configKey.name());
        return orgWxConfigDao.queryByCondition(condition, null);

    }
    
    

    private List<String> getConfigKeyNames(List<ConfigKeyEnum> configKeyList){
        List<String> nameList = Lists.newArrayList();
        for(ConfigKeyEnum key:configKeyList){
            nameList.add(key.name());
        }
        return nameList;
    }

    @Override
    public WxConfig getByKey(Long orgId, ConfigKeyEnum configKey) {

        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("bizKey", configKey.name());
        List<WxConfig> list = orgWxConfigDao.queryByCondition(condition, null);
        if(list.size()==1){
            return list.get(0);
        }
        return null;

    }


    @Override
    public String getValueByKey(Long orgId, ConfigKeyEnum configKey) {

        WxConfig  config = this.getByKey(orgId, configKey);
        if(config==null || config.getValue() == null){
            return "";
        }
        return config.getValue();

    }


    @Override
    public void save(WxConfig sysConfig) {
        Long orgId = sysConfig.getOrgId();
        ConfigKeyEnum keyEnum = ConfigKeyEnum.getByName(sysConfig.getBizKey());
        if(getByKey(orgId,keyEnum)!=null){
            orgWxConfigDao.update(sysConfig);
        }
        this.orgWxConfigDao.save(sysConfig);

    }


    @Override
    public List<WxConfig> queryByKeys(Long orgId, Collection<String> keys) {
        if(!ConfigKeyEnum.batchCheckNames(keys)){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "不存在的配置类型");
        }
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("bizKey", keys);
        return orgWxConfigDao.queryByCondition(condition, null);
            
    }

    
    
    @Override
    public List<WxConfig> batchQueryByConfigKeyList(Long orgId,List<ConfigKeyEnum> configKeyList) {

        Map<String,Object> condition = Maps.newHashMap();
        List<String> names = getConfigKeyNames(configKeyList);
        condition.put("orgId", orgId);
        condition.put("bizKey", names);
        List<WxConfig> list = orgWxConfigDao.queryByCondition(condition, null);
        return list;
        /*Map<String,WxConfig> maps = Maps.newHashMap();
        Set<String> resultNameKey = Sets.newHashSet();
        for(WxConfig config:list){
            maps.put(config.getKey(), config);
            resultNameKey.add(config.getKey());
        }
        names.removeAll(resultNameKey);
        Map<String,String> defaultValueMap = ConfigKeyEnum.getDefaultValue(Sets.newHashSet(names));
        
        for(Map.Entry<String,String> entry:defaultValueMap.entrySet()){
            WxConfig config = new WxConfig();
            config.setOrgId(orgId);
            config.setKey(entry.getKey());
            config.setValue(entry.getValue());
            maps.put(entry.getKey(),config);
        }
        
        return Lists.newArrayList(maps.values());*/
        
    }
    
    @Override
    public Map<String,String> batchQueryMapByConfigKeyList(Long orgId,List<ConfigKeyEnum> configKeyList) {

        List<String> names = getConfigKeyNames(configKeyList);
        
        List<WxConfig> wxconfigList = this.batchQueryByConfigKeyList(orgId, configKeyList);
        
        return this.wxConfigList2Map(wxconfigList,names);
        
    }
    
    
    
    @Override
    public List<WxConfig> queryByKeyPrefix(Long orgId, String namePrefix) {
        
        List<String> names = ConfigKeyEnum.listNameByNamePrefix(namePrefix);
        if(CollectionUtils.isEmpty(names)){
            return Lists.newArrayList();
        }
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("bizKey", names);
        
        return orgWxConfigDao.queryByCondition(condition, null);
            
    }


    @Override
    public void batchSave(Long orgId, Map<String, String> configMap) {
        
        if(!ConfigKeyEnum.batchCheckNames(configMap.keySet())){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "不存在的配置类型");
        }
        
        List<WxConfig> list = queryByKeys(orgId,configMap.keySet());
        
        Set<String> updateKeys = Sets.newHashSet();
        for(WxConfig config:list){
            String key = config.getBizKey();
            updateKeys.add(key);
        }
        for(Entry<String, String> entry:configMap.entrySet()){
            String tempKey = entry.getKey();
            if(updateKeys.contains(tempKey)){
                Map<String,Object> updateCondtion = Maps.newHashMap();
                updateCondtion.put("orgId", orgId);
                updateCondtion.put("bizKey", tempKey);
                updateCondtion.put("value", entry.getValue());
                
                this.orgWxConfigDao.update(updateCondtion, "value");
            }else{
                WxConfig config = new WxConfig();
                config.setOrgId(orgId);
                config.setBizKey(tempKey);
                config.setValue(entry.getValue());
                try {
                    orgWxConfigDao.save(config);
                } catch (Exception e) {
                    //如果保存失败，来一次更新
                    Map<String,Object> updateCondtion = Maps.newHashMap();
                    updateCondtion.put("orgId", orgId);
                    updateCondtion.put("bizKey", tempKey);
                    updateCondtion.put("value", entry.getValue());
                    
                    this.orgWxConfigDao.update(updateCondtion, "value");
                }
            }
           
        }
        
        return ;
            
    }


    @Override
    public Map<String, String> wxConfigList2Map(List<WxConfig> wxconfigList) {
        
        Map<String,String> map = Maps.newHashMap();
        for(WxConfig config:wxconfigList){
            map.put(config.getBizKey(), config.getValue());
        }
        return map;
            
    }


    @Override
    public Map<String, String> wxConfigList2Map(List<WxConfig> wxconfigList, Collection<String> keys) {
        
        Map<String,String> map = Maps.newHashMap();
        for(WxConfig config:wxconfigList){
            map.put(config.getBizKey(), config.getValue());
        }
        
        keys.removeAll(map.keySet());
        
        Map<String,String> defaultValueMap = ConfigKeyEnum.getDefaultValue(keys);
        map.putAll(defaultValueMap);
        
        return map;
            
    }

}

    