
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.WxConfig;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.wx.api.WxConfigCacheService;
import com.baijia.tianxiao.sal.wx.api.WxConfigService;
import com.baijia.tianxiao.sal.wx.enums.ConfigKeyEnum;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;

import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @title OrgWxConfigCacheServiceImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年12月28日
 * @version 1.0
 */
@Slf4j
@Service("wxConfigCacheService")
public class WxConfigCacheServiceImpl implements WxConfigCacheService{

    
    @Resource
    private WxConfigService wxConfigService;
    
    @Resource
    private TXAccountService txAccountService;
    
    @Resource
    private OrgAccountService orgAccountService;
    
    @Resource
    private OrgSubAccountDao orgSubAccountDao;
    
    private Cache<Long, Map<String,String>> orgWxConfigCacheFormCallable = null;
    
    private Cache<Integer, TXAccount> txAccountCacheFormCallable = null;
    
    private Cache<Integer, Integer>  orgNumberCacheMapFormCallable = null;
    
    private Cache<Integer, OrgSubAccount>  orgSubAccountCacheFormCallable = null;
    
    
    
    Map<String,Long> allAliasOrgMap = null;
    
    @PostConstruct
    public void init() throws Exception{
        orgWxConfigCacheFormCallable = callableCached();
        
        txAccountCacheFormCallable = callableCached();
        
        orgNumberCacheMapFormCallable = callableCached();
        
        orgSubAccountCacheFormCallable = callableCached();
    }
    
    /**
     * 对需要延迟处理的可以采用这个机制；(泛型的方式封装)
     * @param <K>
     * @param <V>
     * @param key
     * @param callable
     * @return V
     * @throws Exception
     */
    public static <K,V> Cache<K , V> callableCached() throws Exception {
          Cache<K, V> cache = CacheBuilder
          .newBuilder()
          .maximumSize(10000)
          .expireAfterWrite(5, TimeUnit.MINUTES)
          .build();
          return cache;
    }
    
    
    
    private Map<String,String> getWxConfigCallableCache(final Long orgId) {
        try {
            // Callable只有在缓存值不存在时，才会调用
            return orgWxConfigCacheFormCallable.get(orgId, new Callable<Map<String,String>>() {
                @Override
                public Map<String,String> call() throws Exception {
                    return listAllOrgConfig(orgId);
                }
            });
        } catch (ExecutionException e) {
            log.error("",e);
            return null;
        } catch(Throwable e){
            log.warn("",e);
            return null;
        }
    }
    
    
    private OrgSubAccount orgSubAccountCacheFormCallable(final Integer orgId) {
        try {
            // 涨姿势了
            // Callable只有在缓存值不存在时，才会调用
            return orgSubAccountCacheFormCallable.get(orgId, new Callable<OrgSubAccount>() {
                @Override
                public OrgSubAccount call() throws Exception {
                    return getSubAccount(orgId);
                }
            });
        } catch (ExecutionException e) {
            log.error("",e);
            return null;
        } catch(Throwable e){
            log.warn("",e);
            return null;
        }
    }
    
    private TXAccount getTxAccountCallableCache(final Integer orgId) {
        try {
            // 涨姿势了
            // Callable只有在缓存值不存在时，才会调用
            return txAccountCacheFormCallable.get(orgId, new Callable<TXAccount>() {
                @Override
                public TXAccount call() throws Exception {
                    return getTxAccout(orgId);
                }
            });
        } catch (ExecutionException e) {
            log.error("",e);
            return null;
        } catch(Throwable e){
            log.warn("",e);
            return null;
        }
    }
    
    private Integer getOrgIdByNumberCallableCache(final Integer number) {
        try {
            // 涨姿势了
            // Callable只有在缓存值不存在时，才会调用
            return orgNumberCacheMapFormCallable.get(number, new Callable<Integer>() {
                @Override
                public Integer call() throws Exception {
                    return getOrgAccount(number);
                }
            });
        } catch (ExecutionException e) {
            log.error("",e);
            return null;
        } catch(Throwable e){
            log.warn("",e);
            return null;
        }
    }
    
    private Integer getOrgAccount(Integer number){
        OrgAccount account = orgAccountService.getOrgAccountByNumber(number.intValue());
        if(account==null){
            return null;
        }
        return account.getId();
    }
    private TXAccount getTxAccout(Integer orgId){
        return this.txAccountService.getTXAccountByOrgId(orgId);
    }
    
    private OrgSubAccount getSubAccount(Integer orgId){
        OrgSubAccount subAcc = orgSubAccountDao.getByOrgId(orgId);
        return subAcc;
    }

    private List<WxConfig> listAllAlias() {
        List<WxConfig> allOrgAliasList = wxConfigService.queryAllByConfigKey(ConfigKeyEnum.wx_alias);
        return allOrgAliasList;
    }
    
    private Map<String,String> listAllOrgConfig(Long orgId) {
        List<WxConfig> wxconfigList = wxConfigService.queryAllByOrgId(orgId);
        return this.wxConfigService.wxConfigList2Map(wxconfigList, ConfigKeyEnum.getAllNames());
    }
    
    @Scheduled(cron="0 0/1 * * * ?")
    public void refresh(){
        List<WxConfig> allOrgAliasList = this.listAllAlias();
        Map<String,Long> tempAliasOrgMap = Maps.newHashMap();
        for(WxConfig config:allOrgAliasList){
            tempAliasOrgMap.put(config.getValue(), config.getOrgId());
        }
        this.allAliasOrgMap = tempAliasOrgMap;
    }
    
    @Override
    public Long getOrgIdByAliasFromLocalCache(String name) {
        if(allAliasOrgMap == null){
            refresh();
        }
        return allAliasOrgMap.get(name);
    }
    
    @Override
    public Map<String,String> getAllOrgConfigFromLocalCache(Long orgId){
        return getWxConfigCallableCache(orgId);
    }
    
    @Override
    public TXAccount getTXAccountFromLocalCache(Integer orgId){
        return getTxAccountCallableCache(orgId);
    }
    
    @Override
    public OrgSubAccount getOrgSubAccountFromLocalCache(Integer orgId){
        return orgSubAccountCacheFormCallable(orgId);
    }
    
    @Override
    public Integer getTxOrgIdByNumberFromLocalCache(Integer orgNum){
        return getOrgIdByNumberCallableCache(orgNum);
    }
}

    