
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.dao.WxCloudSourceDao;
import com.baijia.tianxiao.dal.org.dto.WxCloudSourceDto;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.WxCloudSource;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.cloud.api.VideoApi;
import com.baijia.tianxiao.sal.cloud.model.request.VideoUploadUrlCreate;
import com.baijia.tianxiao.sal.cloud.model.response.DefaultApiResult;
import com.baijia.tianxiao.sal.wx.api.WxCloudSourceService;
import com.baijia.tianxiao.sal.wx.enums.WxErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.date.DateUtil;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @title WxCloudSourceService
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年1月9日
 * @version 1.0
 */
@Slf4j
@Service("wxCloudSourceService")
public class WxCloudSourceServiceImpl implements WxCloudSourceService{

    @Resource
    private WxCloudSourceDao wxCloudSourceDao;
    
    @Resource
    private VideoApi videoApi;
    
    @Resource
    private OrgInfoDao orgInfoDao;
    
    @Resource
    private TXCascadeCredentialDao txCascadeCredentialDao;
    
    @Override
    public void create(WxCloudSource wxCloudSource) {
        
        wxCloudSourceDao.save(wxCloudSource);
            
    }

   

    @Override
    public boolean updateById(WxCloudSource wxCloudSource) {
        
        return 1==wxCloudSourceDao.update(wxCloudSource);
            
    }

    @Override
    public boolean deleteById(Long orgId, Long id) {
        
        Map<String,Serializable> condition = Maps.newHashMap();
        condition.put("id", id);
        condition.put("orgId", orgId);
        WxCloudSource cloudSource = wxCloudSourceDao.getByCondition(condition);
        if(cloudSource == null){
            return false;
        }
        DefaultApiResult result = videoApi.delete(cloudSource.getCloudId());
        if(!(result.getCode()==5002 ||result.getCode()==0)){
            log.warn("videoApi.getUploadUrl fail ,video_id={},result ={}",cloudSource.getCloudId(),result);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "资源删除异常");
        }
        
        Map<String,Object> updateCondtion = Maps.newHashMap();
        updateCondtion.put("id", id);
        updateCondtion.put("orgId", orgId);
        updateCondtion.put("delStatus", 1);
        
        wxCloudSourceDao.update(updateCondtion, "delStatus");
        
        return true;
    }

    @Override
    public boolean updateStatusAndSize(WxCloudSource wxCloudSource) {
        
        
        Map<String,Object> updateCondition = Maps.newHashMap();
        updateCondition.put("id", wxCloudSource.getId());
        updateCondition.put("orgId", wxCloudSource.getOrgId());
        updateCondition.put("status", wxCloudSource.getStatus());
        updateCondition.put("size", wxCloudSource.getSize());
        
        return 1==wxCloudSourceDao.update(updateCondition, "status","size");
    }

    @Override
    public boolean updateCustomInfo(WxCloudSource wxCloudSource) {
        
        /*WxCloudSource oldSource = getByCloudId(wxCloudSource.getBizType(),wxCloudSource.getCloudId());
        wxCloudSource.setId(oldSource.getId());*/
        return 1==wxCloudSourceDao.update(wxCloudSource,"name","tags","info");
            
    }

    @Override
    public Map<String, Object> createVideoSourceUploadUrl(Long orgId, Integer operatorId ,String name, String tags, String info) {
        
        WxCloudSource source = new WxCloudSource();
        source.setOrgId(orgId);
        source.setName(name);
        source.setTags("#"+tags+"#");
        source.setInfo(info);
        source.setIsForbidden(0);
        source.setBizType(1);
        source.setStatus(1);
        source.setVisible(0);
        source.setDelStatus(0);
        source.setCreateUserId(operatorId);
        this.wxCloudSourceDao.save(source);
        VideoUploadUrlCreate videoUpload = new VideoUploadUrlCreate();
        videoUpload.setFile_name(name);
        DefaultApiResult result = videoApi.getUploadUrl(videoUpload);
        if(result.getCode()!=0){
            log.warn("videoApi.getUploadUrl fail ,params={},result ={}",videoUpload,result);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "获取文件上传地址异常");
        }
        String videoId = result.getData().get("video_id").toString();
        
        WxCloudSource updateSource = new WxCloudSource();
        updateSource.setId(source.getId());
        updateSource.setCloudId(Long.valueOf(videoId));
        this.updateById(updateSource);
        Map<String,Object> data = Maps.newHashMap();
        data.put("upload_url", result.getData().get("upload_url").toString());
        data.put("id", source.getId());
        return data;
    }



    @Override
    public WxCloudSource getByCloudId(Integer bizType, Long cloudId) {
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("bizType", bizType);
        condition.put("cloudId", cloudId);
        
        List<WxCloudSource> list = wxCloudSourceDao.queryByCondition(condition, null);
        if(list.size()==0){
            return null;
        }
        
        return list.get(0);
            
    }



    @Override
    public boolean updateStatusAndSizeByCloudId(WxCloudSource wxCloudSource) {
        
        Map<String,Object> updateCondition = Maps.newHashMap();
        updateCondition.put("cloudId", wxCloudSource.getCloudId());
        updateCondition.put("bizType", wxCloudSource.getBizType());
        
        updateCondition.put("status", wxCloudSource.getStatus());
        updateCondition.put("size", wxCloudSource.getSize());
        
        return 1==wxCloudSourceDao.update(updateCondition, "status","size");
            
    }


    @Override
    public Map<String, Object> getResumeVideoSourceUploadUrl(Long orgId, Long id) {
        
        WxCloudSource wxCloudSource = this.getById(orgId, id);
        if(wxCloudSource == null ||wxCloudSource.getCloudId() == null){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "获取文件上传地址异常"); 
        }
        DefaultApiResult result = this.videoApi.getResumeUploadUrl(wxCloudSource.getCloudId());
        if(result.getCode()!=0){
            log.warn("videoApi.getUploadUrl fail ,params={},result ={}",wxCloudSource.getCloudId(),result);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "获取文件上传地址异常");
        }
        String upload_size = result.getData().get("upload_size").toString();
        
        WxCloudSource updateSource = new WxCloudSource();
        updateSource.setId(wxCloudSource.getId());
        updateSource.setSize(Long.valueOf(upload_size));
        this.updateById(updateSource);
        return result.getData();
            
    }



    @Override
    public WxCloudSource getById(Long orgId, Long id) {
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("id", id);
        condition.put("orgId", orgId);
        List<WxCloudSource> list = wxCloudSourceDao.queryByCondition(condition, null);
        if(list.size()==0){
            return null;
        }
        
        return list.get(0);
            
    }



    @Override
    public List<WxCloudSource> listByDtoCondition(WxCloudSourceDto queryDto,PageDto pageDto) {
        if(StringUtils.isNotBlank(queryDto.getKey())){
            queryDto.setNameKey(queryDto.getKey());
            queryDto.setTag(queryDto.getKey());
        }
        if(queryDto.getEndDate()!=null){
            Date realEndDate = DateUtil.addDay(queryDto.getEndDate(), 1);
            queryDto.setEndDate(realEndDate);
        }
        List<WxCloudSource> list = wxCloudSourceDao.listByDtoConditon(queryDto, pageDto);
        buildCreateUserName(queryDto.getOrgId(),list);
        return list;
            
    }



    @Override
    public boolean updateCloudInfoByCloudId(WxCloudSource orgCloudSource) {
        
        WxCloudSource exitCloudSource = this.getByCloudId(orgCloudSource.getBizType(), orgCloudSource.getCloudId());
        if(exitCloudSource == null){
            throw new BussinessException(WxErrorCode.UNKNOW, "视频id不存在");
        }
        orgCloudSource.setId(exitCloudSource.getId());
        int cloudStatus = orgCloudSource.getCloudStatus();
        //上传完成
        if( cloudStatus == 20 ){
            orgCloudSource.setStatus(2);
        }else if(cloudStatus == 30 ){//转码失败
            orgCloudSource.setStatus(4);
        }else if(cloudStatus == 100 ){//转码成功
            orgCloudSource.setStatus(3);
        }
        orgCloudSource.setVisible(1);
        return 1==wxCloudSourceDao.update(orgCloudSource, true,"status","visible","cloudStatus","size","length","prefaceUrl");
        
    }



    @Override
    public String getVideoSign(Long orgId, Long id) {
        
        WxCloudSource cloudSource = getById(orgId,id);
        if(cloudSource.getBizType()==2){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "直播回放不能在资源管理中播放，请在直播回放中查看");
        }
        Long cloudId = cloudSource.getCloudId();
        DefaultApiResult result = videoApi.videoPlaySign(cloudId,180L);
        if(result.getCode()!=0){
            log.warn("videoApi.getUploadUrl fail ,params={},result ={}",cloudId,result);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "获取文件上传地址异常");
        }
        
        return result.getData().get("token").toString();
            
    }



    @Override
    public boolean updateForbidden(Long orgId, Long id, Integer isForbidden) {
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("id", id);
        condition.put("orgId", orgId);
        condition.put("isForbidden", isForbidden);
        return 1==wxCloudSourceDao.update(condition, "isForbidden");
            
    }



    @Override
    public boolean updateVisible(Long orgId, Long id, Integer visible) {
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("id", id);
        condition.put("orgId", orgId);
        condition.put("status", 2);
        condition.put("visible", visible);
        return 1==wxCloudSourceDao.update(condition, "status","visible");
            
    }



    @Override
    public Long getOrgTotalSize(Long orgId) {
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        Long orgTotalSize = wxCloudSourceDao.sumByCondition(condition);
        return orgTotalSize;
    }



    @Override
    public Map<Long, WxCloudSource> getMapByIds(Long orgId, Collection<Long> ids) {
        Map<Long,WxCloudSource> map = Maps.newHashMap();
        if(CollectionUtils.isEmpty(ids)){
            return map;
        }
        List<WxCloudSource> list = wxCloudSourceDao.getByIds(ids);
        for(WxCloudSource cloudSource:list){
            map.put(cloudSource.getId(), cloudSource);
        }
        return map;
    }
    
    private void buildCreateUserName(Long orgId,List<WxCloudSource> list){
        Set<Integer> ids = Sets.newHashSet();
        for(WxCloudSource wxCloudSource:list){
            Integer userId = wxCloudSource.getCreateUserId();
            if(userId!=null){
                ids.add(userId);
            }
        }
        
        Map<Integer, String> map = cacheOperator(orgId,ids);
        
        for(WxCloudSource wxCloudSource:list){
            Integer userId = wxCloudSource.getCreateUserId();
            if(userId!=null){
                String name = map.get(userId);
                wxCloudSource.setCreateUserName(name);
            }
        }
    }
    
    /**
     * 缓存操作人
     * @param ids
     * @return
     */
    private Map<Integer, String> cacheOperator(Long orgId, Collection<Integer> ids) {
        Map<Integer, String> cache = new HashMap<>();
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId.intValue(), "id", "contacts");
        if (orgInfo == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "机构信息不存在");
        }
        cache.put(0, orgInfo.getContacts());
        if (CollectionUtils.isNotEmpty(ids)) {
            Map<Long, String> map = this.txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds(ids);
            if (map != null && map.size() > 0) {
                for (Long id : map.keySet()) {
                    cache.put(id.intValue(), map.get(id));
                }
            }
        }
        return cache;
    }

   
}

    