
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.commons.cache.CacheUtil;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.sal.wx.api.ValidateCodeService;
import com.baijia.tianxiao.sal.wx.model.ValidateCodeSend;
import com.baijia.tianxiao.sal.wx.model.ValidateCodeSend.BizTypeEnum;
import com.baijia.tianxiao.sal.wx.model.ValidateCodeSend.SendTypeEnum;
import com.baijia.tianxiao.sal.wx.result.ValidateCodeSendResult;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Random;

import lombok.extern.slf4j.Slf4j;


@Slf4j
@Service("validateCodeSendService")
public class ValidateCodeServiceImpl implements ValidateCodeService {
	// 内部用的验证码
	private static final String INNER_CHECKCODE = "wx8888";

	@Override
	public ValidateCodeSendResult createAndSendCheckCode(
			ValidateCodeSend validateCodeSend,boolean needSendSms) {
		ValidateCodeSendResult result = new ValidateCodeSendResult();

		try {
			// 获取校验码
			String checkCode = this.getCheckCode(validateCodeSend);
			log.debug("生成的校验码：" + checkCode);
			
			
			
			if(needSendSms){
			    // 获取内容模板
	            //String configName = validateCodeSend.getBizType().name();
	            
	            //暂时还不需要动数据库模版
	            /*CheckcodeTemplate contentTemplate =  checkcodeTemplateService.findCheckcodeTemplate(configName);
	            // 替换模板内容
	            String content = contentTemplate.getContent().replaceFirst("\\$\\{checkCode\\}",checkCode);*/
	            // 替换模板内容
	            String content = validateCodeSend.getContentTemplate();
	            // 替换模板内容
	            content = content.replaceFirst("\\$\\{checkCode\\}",checkCode);
	            String subject = validateCodeSend.getBizType().getSubject();
	            // 发送邮件或短信校验码
	            doSend(validateCodeSend.getSendType(),
	                    validateCodeSend.getSendIdentity(), content, subject);
			}
			
			String bizName = getBizName(validateCodeSend);
			// 写入缓存
			saveCache(validateCodeSend.getSendIdentity(), bizName, checkCode,
					validateCodeSend.getEffectMinute());
			result.setSuccess(true);
			result.setCheckCode(checkCode);
	        return result;
		} catch (Exception e) {
			
			result.setMsg(ValidateCodeSendResult.ResultCodeEnum.System_exception
                    .getDesc());
			log.error(
					"ValidateCodeSendService.createAndSendCheckCode  excute exception",
					e);
			return result;
		}
		
	}

	

	@Override
	public ValidateCodeSendResult check(ValidateCodeSend validateCodeSend,
			String code) {

		ValidateCodeSendResult result = new ValidateCodeSendResult();
		
		String bizName;
			bizName = getBizName(validateCodeSend);
		
		// 全局验证码，测试用
		if (StringUtils.equals(code, INNER_CHECKCODE)) {
			removeCache(validateCodeSend.getSendIdentity(), bizName);
			result.setSuccess(true);
			return result;
		}

		Object o = getCache(validateCodeSend.getSendIdentity(), bizName);
		if (o == null) {
			result.setMsg(ValidateCodeSendResult.ResultCodeEnum.ExpiredOrNoExist.getDesc());
			return result;
		}
		String cacheCode = (String) o;
		if (!StringUtils.equals(cacheCode, code)) {
			result.setMsg(ValidateCodeSendResult.ResultCodeEnum.Code_match_error.getDesc());
			return result;
		}
		result.setSuccess(true);
		removeCache(validateCodeSend.getSendIdentity(), bizName);
		return result;
	}

	private String getBizName(ValidateCodeSend validateCodeSend){
		String bizName;
		BizTypeEnum bizType = validateCodeSend.getBizType();
		if(bizType == null){
		    bizType = BizTypeEnum.Default;
		}
		if (bizType == BizTypeEnum.Other) {
			bizName = validateCodeSend.getOtherBizName();
		} else {
		    bizName = bizType.name();
		}
		return bizName;
	}

	

	private String getCheckCode(ValidateCodeSend validateCodeSend){
		String code;
		SendTypeEnum sendTypeEnum = validateCodeSend.getSendType();

		if (sendTypeEnum == SendTypeEnum.SMS) {
			code = createMobileCode();
		} else if (sendTypeEnum == SendTypeEnum.EMAIL) {
			code = createEmailCode();
		} else {
			code = createMobileCode();
		}
		return code;
	}

	private void saveCache(String identity, String bizTypeName,
			String checkCode, int effectMinute) {
		CacheUtil.set(RedisKeyEnums.WX.VALIDATECODEPREFIX.getRedisKey() + bizTypeName + "_" + identity,
				checkCode, effectMinute * 60);
	}

	private Object getCache(String identity, String bizTypeName) {
		return CacheUtil.getValue(RedisKeyEnums.WX.VALIDATECODEPREFIX.getRedisKey() + bizTypeName + "_"
				+ identity);
	}

	private void removeCache(String identity, String bizTypeName) {
	    CacheUtil.delete(RedisKeyEnums.WX.VALIDATECODEPREFIX.getRedisKey() + bizTypeName + "_" + identity);
	}

	private void doSend(SendTypeEnum sendTypeEnum, String identity,
			String content, String subject) {
		if (sendTypeEnum == SendTypeEnum.SMS) {
			sendSMS(identity, content);
		} else {
			sendEmail(identity, content, subject);
		}
	}

	private void sendSMS(String mobile, String content) {
		log.info("sms send,mobile=" + mobile + "content=" + content);
		try {
			//CommonSMSService.sendSMS(mobile, content);
		} catch (Exception e) {
			log.error("",e);
		}
	}

	private void sendEmail(String email, String content, String subject) {
		/*
		 * System.out.println("email:"+content); EmailSender emailSender = new
		 * EmailSender(true); try { emailSender.sendEmail(Arrays.asList(email),
		 * subject, content); } catch (EmailException e) {
		 * logger.error("邮箱发送失败，email="+email); e.printStackTrace(); }
		 */
		//SendCloudMail.send(email, subject, content);
	}

	private String createMobileCode() {
		int number = new Random().nextInt(1000000);
		String str1 = String.format("%06d", number);
		return str1;
	}

	private String createEmailCode() {
		int number = new Random().nextInt(1000000);
		String str1 = String.format("%06d", number);
		return str1;
	}

//	public static void main(String[] args) {
//		/*String contentTemplate = ValidateCodeSend.BizTypeEnum.MailBindEmail
//				.getContent();
//		// System.out.println(contentTemplate);
//		// String contentTemplate = "abcccc#{checkCode}";
//		System.out.println(contentTemplate);
//		String content = contentTemplate.replaceFirst("#\\{checkCode\\}",
//				"12345");
//		System.out.println(content);*/
//	}
//
//	public String createExtralCacheCode(String identity){
//		String randomNumber= createRandomNumber();
//		CacheUtil.set(identity, randomNumber, 120);
//		return randomNumber;
//	}
//	
//	public boolean checkExtralCacheCode(String identity,String code){
//		Object o = CacheUtil.getValue(identity);
//		if(o!=null){
//		    CacheUtil.delete(identity);
//			return true;
//		}
//		return false;
//	}
	
	private String createRandomNumber(){
		int number = new Random().nextInt(1000000);
		String str1 = String.format("%06d", number);
		return str1;
	}
}
