
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.enums;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;
import com.baijia.tianxiao.util.ErrorCodeUtil;

/**
 * @title WxErrorCode
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年1月5日
 * @version 1.0
 */

public enum WxErrorCode implements UniverseErrorCode{
    

    
    UNKNOW(1, "未知类型错误"),
    
    ACCESS_LOGIN_INVALID(10,"未登录或登录失效"),
    ACCESS_LOGIN_OTHERS(11,"帐号在别处登录，踢下线"),

    LOGIN_ERROR(100, "请求参数不合法"),
    
    LOGIN_NEED_CODE(103, "需要图片验证码"),

    STUDENT_NOT_EXIST(1000, "学员不存在或已被删除"),

    STUDENT_NOT_IN_ORG(1001, "学员不属于机构"),

    MOBILE_NOT_CHANGE(1002, "绑定失败, 新手机号与原手机号相同"),

    CATEGORY_NAME_EXIST(1003, "分类名已存在"),

    BUY_FAILD(1004, "支付失败"),
    
    
    ;
    private int code;
    private String message;
    
    

    private WxErrorCode(Integer code,String message) {
        this.code = code;
        this.message = message;
    }
    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getErrorSide()
     */
    @Override
    public ErrorSide getErrorSide() {
        return ErrorSide.SERVER;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getSystem()
     */
    @Override
    public Subsystem getSystem() {
        return Subsystem.WANGXIAO;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getPlatform()
     */
    @Override
    public Platform getPlatform() {
        return Platform.PC;
    }

    @Override
    public int getSubsystemErrorCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public WxErrorCode fromCode(int code) {
        for (WxErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return WxErrorCode.UNKNOW;
    }

    public static void main(String args[]) {
        System.out.println(ErrorCodeUtil.getUniverseErrorCode(UNKNOW));
    }
    
}

    