
package com.baijia.tianxiao.sal.wx.enums;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public enum ConfigKeyEnum {
    
    
    /**
     * number别名,用来代替机构number
     */
    wx_alias(null),
    
    /**
     * 机构自有域名，
     */
    wx_domain(null),
    
    /**
     * 网校选择的模版
     */
    wx_template("WXT001"),
    
    /**
     * 网校logo
     */
    wx_show_logo("https://imgs.genshuixue.com/0baijiatools/6d54ab97342e68b55eb4ff7f41b92ded/logo.png"),
    
    /**
     * 展示的400电话
     */
        
    wx_show_400("4000515157"),
    
    /**
     * 展示的400相关提示
     */
        
    wx_show_400msg("24小时咨询客服"),
    
    /**
     * 网校banner图刷新时间
     */
        
    wx_banner_time("5000"),
    
    /**
     * 网校banner切换模式
     */
        
    /*wx_banner_mode(null),*/
    
    /**
     * 网校banner高度
     */
        
    wx_banner_height("400"),
    
    /**
     * 网校banner是否自动刷新
     */
        
    wx_banner_auto("true"),
    
    /**
     * 菜单栏名字－主页
     */
        
    wx_name_menubar_home("主页"),
    
    /**
     * 菜单栏名字－课程
     */
        
   
    wx_name_menubar_course("课程"),
    
    /**
     * 菜单栏名字－新闻
     */
        
    wx_name_menubar_news("新闻"),
    
    /**
     * 菜单栏名字－我们
     */
        
    wx_name_menubar_us("我们"),
    
    /**
     * 区域名字-课程
     */
        
    wx_name_area_course("推荐课程"),
    
    wx_title_area_course(""),
    
    /**
     * 区域名字－金牌课
     */
        
    wx_name_area_goldcourse("金牌课"),
    
    /**
     * 区域名字－老师
     */
        
    wx_name_area_teachers("师资团队"),
    
    /**
     * 区域名字－老师－标题
     */
        
    wx_title_area_teachers("金牌师资简介"),
    
    /**
     * 区域名字－新闻
     */
        
    wx_name_area_news("新闻中心"),
    
    /**
     * 区域名字－新闻-标题
     */
        
    wx_title_area_news("NEWS"),

    /**
     * 区域名字-联系我们-标题
     */
    wx_name_area_us("我们"),

    /**
     * 区域名字-联系我们-副标题
     */
    wx_title_area_us("我们"),
    
    
    /**
     * 合同月流量
     *//*
        
    wx_contract_monthflow("5000"),
    
    *//**
     * 合同云端空间大小
     *//*
        
    wx_contract_cloudsize("5000"),
    
    
    *//**
     * 合同并发数
     *//*
        
    wx_contract_concurrency("10"),*/
    
    
    wx_conf_area_teacher_num("3"),
    
    wx_conf_area_course_num("4"),
    
    wx_conf_area_goldcourse_num("4"),
    
    wx_page_title(""),
    
    wx_page_icon(""),
    
    wx_page_word(""),
    
    wx_page_desc(""),
    
    ;
    private String defaultValue;
    
    
    public String getDefaultValue() {
    
        return defaultValue;
    }
    
    private ConfigKeyEnum(String defaultValue) {

        this.defaultValue = defaultValue;

    }

    public static ConfigKeyEnum getByName(String syskey) {
        if (StringUtils.isBlank(syskey)) {
            return null;
        }
        for (ConfigKeyEnum configKeyEnum : ConfigKeyEnum.values()) {
            if (StringUtils.equals(configKeyEnum.name(), syskey)) {
                return configKeyEnum;
            }
        }
        return null;
    }
    
    public static List<ConfigKeyEnum> listByNamePrefix(String namePrefix){
        if (StringUtils.isBlank(namePrefix)) {
            return Lists.newArrayList();
        }
        List<ConfigKeyEnum> enumList = Lists.newArrayList();
        for (ConfigKeyEnum configKeyEnum : ConfigKeyEnum.values()) {
            if (StringUtils.startsWith(configKeyEnum.name(), namePrefix)) {
                enumList.add(configKeyEnum);
            }
        }
        return enumList;
    }
    
    public static List<String> listNameByNamePrefix(String namePrefix){
        if (StringUtils.isBlank(namePrefix)) {
            return Lists.newArrayList();
        }
        List<String> nameList = Lists.newArrayList();
        for (ConfigKeyEnum configKeyEnum : ConfigKeyEnum.values()) {
            if (StringUtils.startsWith(configKeyEnum.name(), namePrefix)) {
                nameList.add(configKeyEnum.name());
            }
        }
        return nameList;
    }
    
    public static boolean batchCheckNames(Collection<String> names){
        if (CollectionUtils.isEmpty(names)) {
            return false;
        }
        List<String> nameList = Lists.newArrayList();
        
        for (ConfigKeyEnum configKeyEnum : ConfigKeyEnum.values()) {
            nameList.add(configKeyEnum.name());
        }
        return nameList.containsAll(names);
    }
    
    public static Map<String,String> getDefaultValue(Collection<String> names){
        Map<String,String> nameDefaultValueMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(names)) {
            return nameDefaultValueMap;
        }
        
        for (ConfigKeyEnum configKeyEnum : ConfigKeyEnum.values()) {
            
            if(names.contains(configKeyEnum.name())){
                nameDefaultValueMap.put(configKeyEnum.name(), configKeyEnum.getDefaultValue());
            }
            
        }
        return nameDefaultValueMap;
    }
    
    public static Collection<String> getAllNames(){
        
        List<String> names = Lists.newArrayList();
        
        for (ConfigKeyEnum configKeyEnum : ConfigKeyEnum.values()) {
            
            names.add(configKeyEnum.name());
            
        }
        return names;
    }
    
    
}

    