
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.api;

import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.sal.wx.model.WxCourseStudentInfo;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.List;

/**
 * @title WxStudentCourseService
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年2月5日
 * @version 1.0
 */

public interface WxStudentCourseService {

    List<WxCourseStudentInfo> queryPageStudentsByCourseId(Long orgId,Long courseId,PageDto pageDto);
    
    List<WxCourseStudentInfo> queryPageStudentsByCourseIdAndMaxId(Long orgId,Long courseId,Integer pageSize,Long id);
    
    void doStudentLessonAndSignByOrgStudentCourseId(Long orgStudentCourseId,boolean needSign);
    
    /**
     * 网校报名进班成功后调用这个方法，里面会处理网校的特殊逻辑
     * 
     * @param orgCourse
     * @param orgStudentCourseId   
     */
        
    void doWxStudentLesson(OrgCourse orgCourse,OrgStudentCourse orgStudentCourse);

    /**
     * task处理网校学员支付成功后:自动排课+课程计数
     * @param orgCourse
     * @param orgStudentCourse
     */
    void taskProcess(OrgCourse orgCourse, OrgStudentCourse orgStudentCourse);
    
}

    