
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.api;

import com.baijia.tianxiao.dal.org.po.WxConfig;
import com.baijia.tianxiao.sal.wx.enums.ConfigKeyEnum;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @title OrgWxConfigService
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年12月28日
 * @version 1.0
 */

public interface WxConfigService {

    List<WxConfig> queryAllByOrgId(Long orgId);
    
    List<WxConfig> queryAllByConfigKey(ConfigKeyEnum configKey);

    WxConfig getByKey(Long orgId,ConfigKeyEnum configKey);

    String getValueByKey(Long orgId,ConfigKeyEnum configKey);

    //String getValueFromLocalCache(Long orgId,OrgWxConfig.ConfigKeyEnum configKey);

    void save(WxConfig sysConfig);
    
    List<WxConfig> queryByKeys(Long orgId,Collection<String> keys);
    
    List<WxConfig> queryByKeyPrefix(Long orgId,String namePrefix);
    
    void batchSave(Long orgId,Map<String,String> configMap);
    
    List<WxConfig> batchQueryByConfigKeyList(Long orgId,List<ConfigKeyEnum> configKeyList);
    
    Map<String,String> batchQueryMapByConfigKeyList(Long orgId,List<ConfigKeyEnum> configKeyList);
    
    Map<String,String> wxConfigList2Map(List<WxConfig> wxconfigList);
    
    Map<String,String> wxConfigList2Map(List<WxConfig> wxconfigList,Collection<String> keys);
    
    
}

    