package com.baijia.tianxiao.sal.wx.api;

import com.baijia.tianxiao.sal.wx.model.WxCategoryDto;

import java.util.Collection;
import java.util.List;

/**
 * 网校分类管理
 * Created by wangsixia on 2017/1/13.
 */
public interface WxCategoryService {

    /**
     * 添加分类
     * @param orgId
     * @param param
     * @return
     */
    Long add(Long orgId, WxCategoryDto param);

    /**
     * 删除分类
     * @param orgId
     * @param id
     */
    void delete(Long orgId, Long id);

    /**
     * 修改分类名
     * @param orgId
     * @param param
     */
    void mod(Long orgId, Long id, String name);

    /**
     * 获取分类列表
     * @param orgId
     * @param type CategoryType
     * @return
     */
    List<WxCategoryDto> getCategoryList(Long orgId, Integer type);

    /**
     * 分类排序
     * @param orgId
     * @param type CategoryType
     * @param ids
     */
    void order(Long orgId, Integer type, List<Long> ids);
}
