
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.cloud.api;

import com.baijia.tianxiao.sal.cloud.model.request.VideoUploadUrlCreate;
import com.baijia.tianxiao.sal.cloud.model.response.DefaultApiResult;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.properties.PropertiesReader;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.MissingResourceException;

import javax.annotation.PostConstruct;

/**
 * @title VideoApi
 * @desc TODO
 * @author leiruiqi
 * @date 2016年12月26日
 * @version 1.0
 */

@Service("videoApi")
@Slf4j
public class VideoApi extends BaseCloudApi {

    private String videoApiBaseUrl = null;

    private String videoDataApiBaseUrl = null;

    @PostConstruct
    public void init() {
        try {
            String baseDomain = PropertiesReader.getValue("cloud", "baijiacloud.domain");
            videoApiBaseUrl = baseDomain + "/openapi/video/";
            videoDataApiBaseUrl = baseDomain + "/openapi/video_data/";
        } catch (MissingResourceException e) {
            log.info("can not init VideoApi cause by :{} ", e);
        }
    }

    public DefaultApiResult getUploadUrl(VideoUploadUrlCreate videoUpload) {
        Map<String, String> params = Maps.newHashMap();

        init(params);

        params.put("file_name", videoUpload.getFile_name());
        params.put("type", videoUpload.getType());
        params.put("definition", videoUpload.getDefinition());
        params.put("priority", videoUpload.getPriority().toString());

        buidlSign(params);

        String str = HttpClientUtils.doPost(videoApiBaseUrl + "getUploadUrl", params);

        return JSON.parseObject(str, DefaultApiResult.class);
    }

    public DefaultApiResult getResumeUploadUrl(Long videoId) {

        Map<String, String> params = Maps.newHashMap();

        init(params);

        params.put("video_id", videoId.toString());

        buidlSign(params);

        String str = HttpClientUtils.doPost(videoApiBaseUrl + "getResumeUploadUrl", params);

        return JSON.parseObject(str, DefaultApiResult.class);
    }

    public DefaultApiResult getInfo(Long videoId) {

        Map<String, String> params = Maps.newHashMap();

        initPartnerId(params);

        params.put("video_id", videoId.toString());
        
        params.put("timestamp", String.valueOf(DateUtil.currentUnixTimestamp()));

        buidlSign(params);

        String str = HttpClientUtils.doPost(videoApiBaseUrl + "getInfo", params);

        return JSON.parseObject(str, DefaultApiResult.class);
    }

    public DefaultApiResult update(Long videoId, String name) {

        Map<String, String> params = Maps.newHashMap();

        initPartnerId(params);

        params.put("video_id", videoId.toString());

        params.put("name", name);

        buidlSign(params);

        String str = HttpClientUtils.doPost(videoApiBaseUrl + "update", params);

        return JSON.parseObject(str, DefaultApiResult.class);
    }

    public DefaultApiResult delete(Long videoId) {

        Map<String, String> params = Maps.newHashMap();

        initPartnerId(params);

        params.put("video_id", videoId.toString());

        params.put("timestamp", String.valueOf(DateUtil.currentUnixTimestamp()));

        buidlSign(params);

        String str = HttpClientUtils.doPost(videoApiBaseUrl + "delete", params);

        return JSON.parseObject(str, DefaultApiResult.class);
    }

    public DefaultApiResult videoPlaySign(Long videoId, Long expires_in) {

        Map<String, String> params = Maps.newHashMap();

        initPartnerId(params);

        params.put("video_id", videoId.toString());

        params.put("expires_in", expires_in.toString());

        params.put("timestamp", String.valueOf(DateUtil.currentUnixTimestamp()));

        buidlSign(params);

        String str = HttpClientUtils.doPost(videoApiBaseUrl + "getPlayerToken", params);

        return JSON.parseObject(str, DefaultApiResult.class);
    }

    public JSONObject batchQueryVideoInfo(int page, int pageSize, String dateStr) {

        Map<String, String> params = Maps.newHashMap();
        initPartnerId(params);
        params.put("page", String.valueOf(page));
        params.put("page_size", String.valueOf(pageSize));
        params.put("date", dateStr);
        params.put("timestamp", String.valueOf(DateUtil.currentUnixTimestamp()));

        buidlSign(params);
        log.info("batchQueryVideoInfo.params:{}", params);
        String str = HttpClientUtils.doPost(videoDataApiBaseUrl + "exportPartnerVideoStatDay", params);

        return JSON.parseObject(str);
    }
}
