
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.cloud.api;

import com.baijia.tianxiao.sal.wx.constant.BaijiaCloudConstant;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.encrypt.MD5Utils;

import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.extern.slf4j.Slf4j;

/**
 * @title BaseCloudApi
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年12月26日
 * @version 1.0
 */
@Slf4j
public abstract class BaseCloudApi {

    
    
    protected void init(Map<String, String> params){
        
        params.put("partner_id", BaijiaCloudConstant.partner_id);
        
        params.put("timestamp", String.valueOf(DateUtil.currentUnixTimestamp()));
        
    }
    
    protected void initPartnerId(Map<String, String> params){
        
        params.put("partner_id", BaijiaCloudConstant.partner_id);
        
        
    }
    
    protected void buidlSign(Map<String, String> params){
        
        StringBuilder sb = new StringBuilder();
        Set<String> keyset = params.keySet();
        List<String> list=new ArrayList<String>(keyset);
        Collections.sort(list);  
        for(String key:list){
            String value = params.get(key);
            sb.append(key+"=");
            if(StringUtils.isNotBlank(value)){
                sb.append(value);
            }
            sb.append("&");
        }
        sb.append("partner_key="+BaijiaCloudConstant.partner_key);
        String  origin_str = sb.toString();
        log.info("sign="+origin_str);
        String sign = MD5Utils.MD5Encode32(origin_str);
        log.info("origin_str="+origin_str+"sign="+sign);
        params.put("sign", sign) ;  
    }
    
    
}

    