/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.util;

import java.util.Random;
import org.apache.commons.lang3.StringUtils;

public class ValidateUtil {
    private static String regpw = "^[^\\s]{6,16}$";
    private static String regEmail = "^(\\w)+(\\.\\w+)*@(\\w)+((\\.\\w{2,3}){1,3})$";
    private static String regIdCard = "(^\\d{15}$)|(^\\d{17}([0-9]|X)$)";
    private static String regMobile = "^[1][1,2,3,4,5,6,7,8,9][0-9]{9}$";
    private static String regPw = "^[a-zA-Z]\\w{5,17}$";
    private static String regPw2 = "^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{8,16}$";

    public static boolean isMobileAllowed(String mobile) {
        if (StringUtils.isNotBlank((CharSequence)mobile)) {
            return mobile.matches(regMobile);
        }
        return false;
    }

    public static boolean isEmailAllowed(String email) {
        if (StringUtils.isNotBlank((CharSequence)email)) {
            return email.matches(regEmail);
        }
        return false;
    }

    public static boolean isIdCardAllowed(String idCard) {
        if (StringUtils.isNotBlank((CharSequence)idCard)) {
            return idCard.matches(regIdCard);
        }
        return false;
    }

    public static boolean isPwAllowed(String pwd) {
        if (StringUtils.isNotBlank((CharSequence)pwd)) {
            return pwd.matches(regPw2);
        }
        return false;
    }

    public static String getRandom(int length, Boolean isCapital, boolean needNumer) {
        String result = "";
        if (length > 0) {
            Random random = new Random();
            for (int i = 0; i < length; ++i) {
                boolean isChar;
                boolean bl = needNumer ? random.nextInt(2) % 2 == 0 : (isChar = true);
                if (isChar) {
                    int begin = isCapital != null ? (isCapital != false ? 65 : 97) : (random.nextInt(2) % 2 == 0 ? 65 : 97);
                    result = result + (char)(random.nextInt(26) + begin);
                    continue;
                }
                result = result + String.valueOf(random.nextInt(10));
            }
        }
        return result;
    }

    public static void main(String[] args) {
        String pws = "1234abcd";
        System.out.println(pws.matches(regPw2));
        System.out.println(ValidateUtil.getRandom(8, true, true));
        System.out.println(ValidateUtil.getRandom(8, false, true));
        System.out.println(ValidateUtil.getRandom(8, null, true));
        System.out.println(ValidateUtil.getRandom(8, true, false));
        System.out.println(ValidateUtil.getRandom(8, false, false));
        System.out.println(ValidateUtil.getRandom(8, null, false));
    }
}

