/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.model;

import com.baijia.tianxiao.constant.PublishStatus;
import com.baijia.tianxiao.dal.org.po.WxCategory;
import com.baijia.tianxiao.dal.org.po.WxNews;
import com.baijia.tianxiao.sal.wx.model.WxNewsBaseDto;
import com.baijia.tianxiao.util.HtmlUtils;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class WxNewsDto
extends WxNewsBaseDto {
    private static final int CUT_LENGTH = 100;
    private static final String CUT_STRING = "...";
    private String richContent;
    private String textContent;

    public void toPo(WxNews po, Integer operatorId, Long orgId) {
        if (this.getId() == null) {
            po.setCreateTime(new Date());
            po.setOrgId(orgId);
            po.setOperatorId(operatorId);
        }
        po.setCategoryId(this.getCategoryId());
        po.setTitle(this.getTitle());
        if (StringUtils.isNotBlank((CharSequence)this.getRichContent())) {
            po.setRichContent(this.getRichContent());
            po.setTextContent(HtmlUtils.html2Text((String)this.getRichContent()));
        }
        po.setCoverId(this.getCoverId());
        if (this.getStatus() != null && this.getStatus().intValue() == PublishStatus.PUBLISH.getCode()) {
            po.setPublishTime(new Date());
            po.setStatus(Integer.valueOf(PublishStatus.PUBLISH.getCode()));
        } else {
            po.setPublishTime(null);
            po.setStatus(Integer.valueOf(PublishStatus.UN_PUBLISH.getCode()));
        }
        po.setStatus(Integer.valueOf(this.getStatus() == null ? PublishStatus.UN_PUBLISH.getCode() : this.getStatus().intValue()));
        po.setUpdateTime(new Date());
    }

    public static WxNewsDto getFromPo(WxNews po, Map<Long, WxCategory> categoryMap, Map<Long, String> coverMap, Map<Integer, String> operatorMap) {
        WxNewsDto dto = new WxNewsDto();
        dto.setId(po.getId());
        dto.setTitle(po.getTitle());
        dto.setCategoryId(po.getCategoryId());
        dto.setCategoryName(categoryMap != null && categoryMap.containsKey(po.getCategoryId()) ? categoryMap.get(po.getCategoryId()).getName() : "");
        dto.setStatus(po.getStatus());
        dto.setStatusStr(PublishStatus.getByCode((Integer)po.getStatus()));
        dto.setCoverId(po.getCoverId());
        dto.setCoverUrl(coverMap != null && coverMap.containsKey(po.getCoverId()) ? coverMap.get(po.getCoverId()) : "https://img.gsxservice.com/0baijiatools/4d7b6a21d35acc6f57f273e0f9db62b4/news.png");
        dto.setCreateTime(po.getCreateTime());
        dto.setPublishTime(po.getPublishTime());
        if (po.getTextContent().length() > 100) {
            dto.setShortContent(StringUtils.substring((String)po.getTextContent(), (int)0, (int)100) + CUT_STRING);
        } else {
            dto.setShortContent(po.getTextContent());
        }
        dto.setOperatorId(po.getOperatorId());
        dto.setOperatorName(operatorMap != null && operatorMap.containsKey(po.getOperatorId()) ? operatorMap.get(po.getOperatorId()) : "");
        dto.setRichContent(po.getRichContent());
        dto.setTextContent(po.getTextContent());
        return dto;
    }

    public String getRichContent() {
        return this.richContent;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setRichContent(String richContent) {
        this.richContent = richContent;
    }

    public void setTextContent(String textContent) {
        this.textContent = textContent;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxNewsDto)) {
            return false;
        }
        WxNewsDto other = (WxNewsDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$richContent = this.getRichContent();
        String other$richContent = other.getRichContent();
        if (this$richContent == null ? other$richContent != null : !this$richContent.equals(other$richContent)) {
            return false;
        }
        String this$textContent = this.getTextContent();
        String other$textContent = other.getTextContent();
        return !(this$textContent == null ? other$textContent != null : !this$textContent.equals(other$textContent));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxNewsDto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $richContent = this.getRichContent();
        result = result * 59 + ($richContent == null ? 43 : $richContent.hashCode());
        String $textContent = this.getTextContent();
        result = result * 59 + ($textContent == null ? 43 : $textContent.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "WxNewsDto(richContent=" + this.getRichContent() + ", textContent=" + this.getTextContent() + ")";
    }
}

