/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.WxTemplateConfigDao;
import com.baijia.tianxiao.dal.org.dao.WxTemplateDao;
import com.baijia.tianxiao.dal.org.po.WxTemplate;
import com.baijia.tianxiao.dal.org.po.WxTemplateConfig;
import com.baijia.tianxiao.sal.wx.api.WxTemplateConfigService;
import com.baijia.tianxiao.sal.wx.enums.ConfigKeyEnum;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="wxTemplateConfigService")
public class WxTemplateConfigServiceImpl
implements WxTemplateConfigService {
    @Resource
    private WxTemplateDao wxTemplateDao;
    @Resource
    private WxTemplateConfigDao orgWxTemplateConfigDao;

    @Override
    public WxTemplateConfig getTemplateConfigByTemplateCode(Long orgId, String templateCode) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("templateCode", templateCode);
        List list = this.orgWxTemplateConfigDao.queryByCondition((Map)condition, null, new String[0]);
        if (list.size() == 1) {
            return (WxTemplateConfig)list.get(0);
        }
        return null;
    }

    @Override
    public boolean updateTemplateConfig(WxTemplateConfig templateConfig) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", templateConfig.getOrgId());
        condition.put("templateCode", templateConfig.getTemplateCode());
        condition.put("value", templateConfig.getValue());
        return 1 == this.orgWxTemplateConfigDao.update((Map)condition, new String[]{"value"});
    }

    @Override
    public void createTemplateConfig(WxTemplateConfig templateConfig) {
        this.orgWxTemplateConfigDao.save((Object)templateConfig, new String[0]);
    }

    @Override
    public void saveTemplateConfig(WxTemplateConfig templateConfig) {
        if (this.getTemplateConfigByTemplateCode(templateConfig.getOrgId(), templateConfig.getTemplateCode()) != null) {
            this.updateTemplateConfig(templateConfig);
        } else {
            this.createTemplateConfig(templateConfig);
        }
    }

    @Override
    public List<WxTemplate> listTemplateConfig(Long orgId) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        List wxTemplateList = this.wxTemplateDao.queryByCondition((Map)condition, null, new String[0]);
        if (CollectionUtils.isEmpty((Collection)wxTemplateList)) {
            WxTemplate defaultTemplate = new WxTemplate();
            defaultTemplate.setCode(ConfigKeyEnum.wx_template.getDefaultValue());
            defaultTemplate.setType(WxTemplate.Type.home.getCode());
            defaultTemplate.setUrl("//imgs.genshuixue.com/0baijiatools/33b5dc5d592df5bf5d2e979f17b7ada6/basicTemplate.png");
            wxTemplateList.add(defaultTemplate);
        }
        return wxTemplateList;
    }
}

