/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.WxBizSchedule;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.wx.api.WxBizScheduleService;
import com.baijia.tianxiao.sal.wx.api.WxStudentCourseService;
import com.baijia.tianxiao.sal.wx.api.WxTaskService;
import com.baijia.tianxiao.sal.wx.enums.BizScheduleType;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WxTaskServiceImpl
implements WxTaskService {
    private static final Logger log = LoggerFactory.getLogger(WxTaskServiceImpl.class);
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgLessonSignService orgLessonSignService;
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private CourseStudentService courseStudentService;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private WxBizScheduleService wxBizScheduleService;
    @Resource
    private WxStudentCourseService wxStudentCourseService;

    @Override
    public void doScheduleExcute() {
        Date now = new Date();
        List<WxBizSchedule> list = this.wxBizScheduleService.queryByScheduleTimeAndStatus(now, 1);
        for (WxBizSchedule schedule : list) {
            this.doWxBizScheduleBiz(schedule);
        }
    }

    private void doWxBizScheduleBiz(WxBizSchedule schedule) {
        int code = schedule.getBizType();
        BizScheduleType type = BizScheduleType.getByCode(code);
        if (type == null) {
            log.warn("doWxBizScheduleBiz fail bizTypeCode not exit code:{}", (Object)code);
            return;
        }
        try {
            if (type == BizScheduleType.course_delay_sign) {
                this.wxBizScheduleService.excuteBizSchedule(type, schedule.getBizKey());
                this.wxStudentCourseService.doStudentLessonAndSignByOrgStudentCourseId(schedule.getBizKey(), true);
            }
            this.wxBizScheduleService.finishBizSchedule(type, schedule.getBizKey());
        }
        catch (Exception e) {
            log.warn("doWxBizScheduleBiz fail bizTypeCode not exit ", (Throwable)e);
            this.wxBizScheduleService.failBizSchedule(type, schedule.getBizKey());
        }
    }
}

